/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperClusterClient;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperMachine;

public class ClusterChecker {
    private final String clusterName;
    private final ZooKeeperClusterClient clusterClient;

    public ClusterChecker(String clusterName, ZooKeeperClusterClient clusterClient) {
        this.clusterName = clusterName;
        this.clusterClient = clusterClient;
    }

    public boolean clusterAlreadyExistsAndThereIsNoMaster() {
        this.clusterClient.waitForSyncConnected();
        try {
            Stat clusterNameStat = this.clusterClient.getZooKeeper(false).exists("/" + this.clusterName, false);
            if (clusterNameStat == null) {
                return false;
            }
            Machine master = this.clusterClient.getMaster();
            return master == ZooKeeperMachine.NO_MACHINE;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to connect to ZooKeeper", e);
        }
        catch (KeeperException e) {
            throw new RuntimeException("There was a problem interacting with ZooKeeper", e);
        }
    }
}

