/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.util.StringLogger;

public class HaCaches
implements Caches {
    private CacheProvider type;
    private Config config;
    private Cache<NodeImpl> node;
    private Cache<RelationshipImpl> relationship;
    private final StringLogger logger;

    public HaCaches(StringLogger logger) {
        this.logger = logger;
    }

    public void configure(CacheProvider newType, Config config) {
        if (!this.cacheConfigSame(newType, config)) {
            this.node = newType.newNodeCache(this.logger, config);
            this.relationship = newType.newRelationshipCache(this.logger, config);
        } else {
            this.node.clear();
            this.relationship.clear();
        }
        this.type = newType;
        this.config = config;
    }

    private boolean cacheConfigSame(CacheProvider type, Config config) {
        return this.type != null && this.type.getName().equals(type.getName()) && "gcr".equals(this.type.getName()) && this.mySettingIsSameAs(config, (GraphDatabaseSetting<?>)GraphDatabaseSettings.node_cache_array_fraction) && this.mySettingIsSameAs(config, (GraphDatabaseSetting<?>)GraphDatabaseSettings.relationship_cache_array_fraction) && this.mySettingIsSameAs(config, (GraphDatabaseSetting<?>)GraphDatabaseSettings.node_cache_size) && this.mySettingIsSameAs(config, (GraphDatabaseSetting<?>)GraphDatabaseSettings.relationship_cache_size);
    }

    private boolean mySettingIsSameAs(Config otherConfig, GraphDatabaseSetting<?> setting) {
        Object myValue = this.config.get(setting);
        Object otherValue = otherConfig.get(setting);
        return myValue.equals(otherValue);
    }

    public Cache<NodeImpl> node() {
        return this.node;
    }

    public Cache<RelationshipImpl> relationship() {
        return this.relationship;
    }

    public void invalidate() {
        this.type = null;
        this.config = null;
    }
}

