/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.com.Client;
import org.neo4j.com.ComException;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.ha.AbstractBroker;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.kernel.ha.zookeeper.AbstractZooKeeperManager;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.util.FileUtils;
import slavetest.CommonJobs;
import slavetest.DoubleLatch;
import slavetest.Fetcher;
import slavetest.SingleJvmTest;
import slavetest.TestMaster;
import slavetest.Worker;

public class SingleJvmWithNettyTest
extends SingleJvmTest {
    private volatile Pair<Master, Machine> cachedMasterOverride;

    @Before
    public void setUp() {
        this.cachedMasterOverride = null;
    }

    @Test
    public void assertThatNettyIsUsed() throws Exception {
        this.initializeDbs(1);
        Assert.assertTrue((String)"Slave Broker is not a client", (boolean)(((HighlyAvailableGraphDatabase)this.getSlave(0)).getBroker().getMaster().first() instanceof MasterClient));
    }

    @Override
    protected Broker makeSlaveBroker(TestMaster master, int masterId, int id, HighlyAvailableGraphDatabase db, Map<String, String> config) {
        config.put("server_id", Integer.toString(id));
        Machine masterMachine = new Machine(masterId, -1, 1L, -1, "localhost:8901");
        int readTimeout = this.getConfigInt(config, HaSettings.read_timeout.name(), 3);
        MasterClient client = new MasterClient((String)masterMachine.getServer().first(), ((Integer)masterMachine.getServer().other()).intValue(), db.getMessageLog(), db.getStoreIdGetter(), Client.ConnectionLostHandler.NO_ACTION, readTimeout, this.getConfigInt(config, HaSettings.lock_read_timeout.name(), readTimeout), 20);
        return new AbstractBroker(new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class, HaSettings.class}).apply(config)), (Master)client, masterMachine){
            final /* synthetic */ Master val$client;
            final /* synthetic */ Machine val$masterMachine;
            {
                this.val$client = master;
                this.val$masterMachine = machine;
                super(x0);
            }

            public boolean iAmMaster() {
                return false;
            }

            public Pair<Master, Machine> getMasterReally(boolean allowChange) {
                if (allowChange) {
                    SingleJvmWithNettyTest.this.cachedMasterOverride = null;
                }
                return this.getMasterPair();
            }

            public Pair<Master, Machine> getMaster() {
                return SingleJvmWithNettyTest.this.cachedMasterOverride != null ? SingleJvmWithNettyTest.this.cachedMasterOverride : this.getMasterPair();
            }

            private Pair<Master, Machine> getMasterPair() {
                return Pair.of((Object)this.val$client, (Object)this.val$masterMachine);
            }

            public Object instantiateMasterServer(GraphDatabaseAPI graphDb) {
                throw new UnsupportedOperationException("cannot instantiate master server on slave");
            }
        };
    }

    private int getConfigInt(Map<String, String> config, String key, int defaultValue) {
        String value = config.get(key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    @Test
    public void makeSureLogMessagesIsWrittenEvenAfterInternalRestart() throws Exception {
        this.initializeDbs(1);
        CountDownLatch latch1 = new CountDownLatch(1);
        GraphDatabaseAPI slave = this.getSlave(0);
        Thread t1 = new Thread((GraphDatabaseService)slave, latch1){
            final /* synthetic */ GraphDatabaseService val$slave;
            final /* synthetic */ CountDownLatch val$latch1;
            {
                this.val$slave = graphDatabaseService;
                this.val$latch1 = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    Transaction tx = this.val$slave.beginTx();
                    this.val$slave.createNode();
                    this.val$latch1.await();
                    tx.success();
                    tx.finish();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        t1.start();
        Thread t2 = new Thread((GraphDatabaseService)slave, latch1){
            final /* synthetic */ GraphDatabaseService val$slave;
            final /* synthetic */ CountDownLatch val$latch1;
            {
                this.val$slave = graphDatabaseService;
                this.val$latch1 = countDownLatch;
            }

            @Override
            public void run() {
                Transaction tx = this.val$slave.beginTx();
                this.val$slave.createNode();
                this.val$latch1.countDown();
                tx.success();
                tx.finish();
            }
        };
        t2.start();
        t1.join();
        t2.join();
        Assert.assertTrue((String)"Did not get enough \"Opened a new channel\" log statements, something went missing", (this.countOccurences("Opened a new channel", new File(this.dbPath(1), "messages.log")) > 1 ? 1 : 0) != 0);
    }

    private int countOccurences(String string, File file) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        int counter = 0;
        while ((line = reader.readLine()) != null) {
            if (!line.contains(string)) continue;
            ++counter;
        }
        reader.close();
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMixingEntitiesFromWrongDbs() throws Exception {
        this.initializeDbs(1);
        GraphDatabaseAPI haDb1 = this.getSlave(0);
        GraphDatabaseAPI mDb = this.getMaster().getGraphDb();
        Transaction tx = mDb.beginTx();
        try {
            Node masterNode = mDb.createNode();
            mDb.getReferenceNode().createRelationshipTo(masterNode, CommonJobs.REL_TYPE);
            tx.success();
        }
        finally {
            tx.finish();
        }
        tx = haDb1.beginTx();
        try {
            Node node = haDb1.createNode();
            mDb.getReferenceNode().createRelationshipTo(node, CommonJobs.KNOWS);
            Assert.fail((String)"Should throw NotFoundException");
        }
        catch (NotFoundException e) {
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void slaveWriteThatOnlyModifyRelationshipRecordsCanUpdateCachedNodeOnMaster() throws Exception {
        long relId;
        Node node;
        this.initializeDbs(1, MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.cache_type.name(), "strong"}));
        HighlyAvailableGraphDatabase sDb = (HighlyAvailableGraphDatabase)this.getSlave(0);
        HighlyAvailableGraphDatabase mDb = this.getMasterHaDb();
        Transaction tx = mDb.beginTx();
        try {
            node = mDb.createNode();
            node.createRelationshipTo(mDb.createNode(), REL_TYPE);
            relId = node.createRelationshipTo(mDb.createNode(), REL_TYPE).getId();
            node.createRelationshipTo(mDb.createNode(), REL_TYPE);
            tx.success();
        }
        finally {
            tx.finish();
        }
        sDb.pullUpdates();
        tx = sDb.beginTx();
        try {
            sDb.getRelationshipById(relId).delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
        int relCount = 0;
        for (Relationship rel : node.getRelationships()) {
            rel.getOtherNode(node);
            ++relCount;
        }
        Assert.assertEquals((String)"wrong number of relationships", (long)2L, (long)relCount);
    }

    @Test
    public void mastersMessagesLogShouldNotContainMentionsAboutAppliedTransactions() throws Exception {
        this.initializeDbs(1);
        for (int i = 0; i < 5; ++i) {
            this.executeJob(new CommonJobs.CreateNodeJob(), 0);
        }
        this.disableVerificationAfterTest();
        this.shutdownDbs();
        List<String> toLookFor = Arrays.asList("applyTxWithoutTxId log version", "Applied external tx and generated");
        Assert.assertEquals((long)0L, (long)this.countMentionsInMessagesLog(new File(this.dbPath(0), "messages.log"), toLookFor));
    }

    private int countMentionsInMessagesLog(File file, Collection<String> toLookFor) {
        int counter = 0;
        for (String line : IteratorUtil.asIterable((File)file)) {
            for (String lookFor : toLookFor) {
                if (!line.contains(lookFor)) continue;
                ++counter;
            }
        }
        return counter;
    }

    @Test
    public void halfWayCopyWithSuccessfulRetry() throws Exception {
        this.startUpMaster(MapUtil.stringMap((String[])new String[0]));
        this.createBigMasterStore(10);
        int slaveMachineId = this.addDb(MapUtil.stringMap((String[])new String[0]), false);
        this.awaitAllStarted();
        this.shutdownDb(slaveMachineId);
        FileUtils.deleteFiles((File)this.dbPath(slaveMachineId), (String)"nioneo.*\\.v.*");
        FileUtils.deleteRecursively((File)new File(this.dbPath(slaveMachineId), "index"));
        Assert.assertTrue((boolean)new File(this.dbPath(slaveMachineId), "neostore").delete());
        Assert.assertTrue((boolean)new File(this.dbPath(slaveMachineId), "neostore.relationshipstore.db").delete());
        File propertyStoreFile = new File(this.dbPath(slaveMachineId), "neostore.propertystore.db");
        FileUtils.truncateFile((File)propertyStoreFile, (long)(propertyStoreFile.length() / 2L));
        this.startDb(slaveMachineId, MapUtil.stringMap((String[])new String[0]), true);
        this.awaitAllStarted();
    }

    @Test
    public void failCommitLongGoingTxOnSlaveAfterMasterRestart() throws Exception {
        this.initializeDbs(1);
        GraphDatabaseAPI master = this.getMaster().getGraphDb();
        Transaction masterTx = master.beginTx();
        long masterNodeId = master.createNode().getId();
        masterTx.success();
        masterTx.finish();
        HighlyAvailableGraphDatabase slave = (HighlyAvailableGraphDatabase)this.getSlave(0);
        slave.pullUpdates();
        Transaction slaveTx = slave.beginTx();
        slave.getNodeById(masterNodeId).setProperty("key", (Object)"value");
        slave.index().forNodes("name").add((PropertyContainer)slave.getNodeById(masterNodeId), "key", (Object)"value");
        long slaveNodeId = slave.createNode().getId();
        this.shutdownMaster();
        HighlyAvailableGraphDatabase newMaster = this.startUpMasterDb(MapUtil.stringMap((String[])new String[0]));
        this.getMaster().setGraphDb((GraphDatabaseAPI)newMaster);
        slaveTx.success();
        try {
            slaveTx.finish();
            Assert.fail((String)"Shouldn't be able to commit here");
        }
        catch (TransactionFailureException e) {
            // empty catch block
        }
        Assert.assertNull((Object)slave.getNodeById(masterNodeId).getProperty("key", null));
        try {
            slave.getNodeById(slaveNodeId);
        }
        catch (NotFoundException e) {
            // empty catch block
        }
    }

    @Test
    public void committsAndRollbacksCountCorrectlyOnMaster() throws Exception {
        this.initializeDbs(1);
        GraphDatabaseAPI master = this.getMaster().getGraphDb();
        GraphDatabaseAPI slave = this.getSlave(0);
        Pair<Integer, Integer> masterTxsBefore = this.getTransactionCounts(master);
        this.executeJobOnMaster(new CommonJobs.CreateNodeJob());
        Assert.assertEquals((Object)Pair.of((Object)((Integer)masterTxsBefore.first() + 1), (Object)masterTxsBefore.other()), this.getTransactionCounts(master));
        masterTxsBefore = this.getTransactionCounts(master);
        Pair<Integer, Integer> slaveTxsBefore = this.getTransactionCounts(slave);
        this.executeJob(new CommonJobs.CreateNodeJob(), 0);
        Assert.assertEquals((Object)Pair.of((Object)((Integer)masterTxsBefore.first() + 1), (Object)masterTxsBefore.other()), this.getTransactionCounts(master));
        Assert.assertEquals((Object)Pair.of((Object)((Integer)slaveTxsBefore.first() + 1), (Object)slaveTxsBefore.other()), this.getTransactionCounts(slave));
        masterTxsBefore = this.getTransactionCounts(master);
        this.executeJobOnMaster(new CommonJobs.CreateNodeJob(false));
        Assert.assertEquals((Object)Pair.of((Object)masterTxsBefore.first(), (Object)((Integer)masterTxsBefore.other() + 1)), this.getTransactionCounts(master));
        masterTxsBefore = this.getTransactionCounts(master);
        slaveTxsBefore = this.getTransactionCounts(slave);
        this.executeJob(new CommonJobs.CreateNodeJob(false), 0);
        Assert.assertEquals((Object)Pair.of((Object)masterTxsBefore.first(), (Object)((Integer)masterTxsBefore.other() + 1)), this.getTransactionCounts(master));
        Assert.assertEquals((Object)Pair.of((Object)slaveTxsBefore.first(), (Object)((Integer)slaveTxsBefore.other() + 1)), this.getTransactionCounts(slave));
    }

    @Test
    public void individuallyConfigurableLockReadTimeout() throws Exception {
        long lockTimeout = 1L;
        this.initializeDbs(1, MapUtil.stringMap((String[])new String[]{HaSettings.lock_read_timeout.name(), String.valueOf(lockTimeout)}));
        final Long nodeId = this.executeJobOnMaster(new CommonJobs.CreateNodeJob(true));
        final Fetcher<DoubleLatch> latchFetcher = this.getDoubleLatch();
        this.pullUpdates(new int[0]);
        Thread lockHolder = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SingleJvmWithNettyTest.this.executeJobOnMaster(new CommonJobs.HoldLongLock(nodeId, latchFetcher));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        lockHolder.start();
        DoubleLatch latch = latchFetcher.fetch();
        latch.awaitFirst();
        long waitStart = System.currentTimeMillis();
        Assert.assertFalse((boolean)this.executeJob(new CommonJobs.SetNodePropertyJob(nodeId, "key", "value"), 0));
        long waitTime = System.currentTimeMillis() - waitStart;
        Assert.assertTrue((String)("" + waitTime), (waitTime < 10000L ? 1 : 0) != 0);
        latch.countDownSecond();
    }

    @Test
    public void useLockTimeoutForCleaningUpTransactions() throws Exception {
        long lockTimeout = 1L;
        this.initializeDbs(1, MapUtil.stringMap((String[])new String[]{HaSettings.lock_read_timeout.name(), String.valueOf(1L)}));
        Long nodeId = this.executeJobOnMaster(new CommonJobs.CreateNodeJob(true));
        final Fetcher<DoubleLatch> latchFetcher = this.getDoubleLatch();
        this.pullUpdates(new int[0]);
        Thread lockHolder = new Thread(new Runnable(){

            @Override
            public void run() {
                DoubleLatch latch = (DoubleLatch)latchFetcher.fetch();
                try {
                    latch.awaitFirst();
                    Thread.sleep(6000L);
                    latch.countDownSecond();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        lockHolder.start();
        try {
            this.executeJob(new CommonJobs.HoldLongLock(nodeId, latchFetcher), 0);
            Assert.fail((String)"Should have cleaned up transaction and thrown exception.");
        }
        catch (TransactionFailureException e) {
            // empty catch block
        }
    }

    @Test
    public void useLockTimeoutToPreventCleaningUpLongRunningTransactions() throws Exception {
        long lockTimeout = 100L;
        this.initializeDbs(1, MapUtil.stringMap((String[])new String[]{HaSettings.lock_read_timeout.name(), String.valueOf(100L)}));
        Long nodeId = this.executeJobOnMaster(new CommonJobs.CreateNodeJob(true));
        final Fetcher<DoubleLatch> latchFetcher = this.getDoubleLatch();
        this.pullUpdates(new int[0]);
        Thread lockHolder = new Thread(new Runnable(){

            @Override
            public void run() {
                DoubleLatch latch = (DoubleLatch)latchFetcher.fetch();
                try {
                    latch.awaitFirst();
                    Thread.sleep(10000L);
                    latch.countDownSecond();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        lockHolder.start();
        this.executeJob(new CommonJobs.HoldLongLock(nodeId, latchFetcher), 0);
    }

    @Test
    public void lockWaitTimeoutShouldHaveSilentTxFinishRollingBackToNotHideOriginalException() throws Exception {
        long lockTimeout = 1L;
        this.initializeDbs(1, MapUtil.stringMap((String[])new String[]{HaSettings.lock_read_timeout.name(), String.valueOf(1L)}));
        Long otherNodeId = this.executeJob(new CommonJobs.CreateNodeJob(true), 0);
        final Fetcher<DoubleLatch> latchFetcher = this.getDoubleLatch();
        ExecutorService executor = Executors.newFixedThreadPool(1);
        final long refNodeId = this.getMasterHaDb().getReferenceNode().getId();
        Future<Void> lockHolder = executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SingleJvmWithNettyTest.this.executeJobOnMaster(new CommonJobs.HoldLongLock(refNodeId, latchFetcher));
                return null;
            }
        });
        DoubleLatch latch = latchFetcher.fetch();
        latch.awaitFirst();
        try {
            this.executeJob(new CommonJobs.SetNodePropertyWithThrowJob(otherNodeId, refNodeId, "key", "value"), 0);
            Assert.fail((String)"Should've failed");
        }
        catch (ComException e) {
            // empty catch block
        }
        latch.countDownSecond();
        Assert.assertNull((Object)lockHolder.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void readLockWithoutTxOnSlaveShouldNotGrabIndefiniteLockOnMaster() throws Exception {
        long lockTimeout = 1L;
        this.initializeDbs(1, MapUtil.stringMap((String[])new String[]{HaSettings.lock_read_timeout.name(), String.valueOf(1L)}));
        final long[] id = new long[1];
        final Fetcher<DoubleLatch> latchFetcher = this.getDoubleLatch();
        Thread lockHolder = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DoubleLatch latch = (DoubleLatch)latchFetcher.fetch();
                try {
                    Node node;
                    GraphDatabaseAPI slaveDb = SingleJvmWithNettyTest.this.getSlave(0);
                    Transaction tx = slaveDb.beginTx();
                    try {
                        node = slaveDb.createNode();
                        tx.success();
                    }
                    finally {
                        tx.finish();
                    }
                    slaveDb.getLockManager().getReadLock((Object)node);
                    slaveDb.getLockReleaser().addLockToTransaction((Object)node, LockType.READ);
                    id[0] = node.getId();
                    latch.countDownFirst();
                    latch.awaitSecond();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        latch.countDownFirst();
                        latch.awaitSecond();
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, "slaveLockHolder");
        lockHolder.start();
        DoubleLatch latch = latchFetcher.fetch();
        latch.awaitFirst();
        HighlyAvailableGraphDatabase masterDb = this.getMasterHaDb();
        Transaction tx = masterDb.beginTx();
        try {
            long startTime = System.currentTimeMillis();
            masterDb.getNodeById(id[0]).setProperty("name", (Object)"David");
            long duration = System.currentTimeMillis() - startTime;
            latch.countDownSecond();
            Assert.assertTrue((String)"Read lock was acquired but not released.", (duration < 1000L ? 1 : 0) != 0);
        }
        finally {
            tx.finish();
        }
    }

    @Test
    public void indexPutIfAbsent() throws Exception {
        this.initializeDbs(2);
        long node = this.executeJobOnMaster(new CommonJobs.CreateNodeJob(true));
        this.pullUpdates(new int[0]);
        Worker t1 = new Worker((GraphDatabaseService)this.getSlave(0));
        Worker t2 = new Worker((GraphDatabaseService)this.getSlave(1));
        t1.beginTx();
        t2.beginTx();
        String index = "index";
        String key = "key";
        String value = "Mattias";
        Assert.assertNull((Object)t2.putIfAbsent(index, node, key, value).get());
        Future<Node> futurePut = t1.putIfAbsent(index, node, key, value);
        t1.waitUntilWaiting();
        t2.finishTx(true);
        Assert.assertNotNull((Object)futurePut.get());
        t1.finishTx(true);
        Assert.assertEquals((long)node, (long)((Node)this.getSlave(0).index().forNodes(index).get(key, (Object)value).getSingle()).getId());
        Assert.assertEquals((long)node, (long)((Node)this.getSlave(1).index().forNodes(index).get(key, (Object)value).getSingle()).getId());
        t1.shutdown();
        t2.shutdown();
    }

    @Test
    public void pullUpdatesDoesNewMasterWhenThereIsNoMaster() throws Exception {
        this.disableVerificationAfterTest();
        this.initializeDbs(2);
        this.executeJob(new CommonJobs.CreateNodeJob(true), 0);
        this.cachedMasterOverride = AbstractZooKeeperManager.NO_MASTER_MACHINE_PAIR;
        this.getMaster().shutdown();
        int exceptionCount = 0;
        for (int i = 0; i < 3; ++i) {
            try {
                this.pullUpdates(1);
                continue;
            }
            catch (Exception e) {
                ++exceptionCount;
                e.printStackTrace();
            }
        }
        if (exceptionCount > 1) {
            Assert.fail((String)"Should not have gotten more than one failed pullUpdates during master switch.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void bruteForceCreateSameRelationshipTypeOnDifferentSlaveAtTheSameTimeShouldYieldSameId() throws Exception {
        int slaves = 3;
        this.initializeDbs(slaves);
        for (int i = 0; i < 10; ++i) {
            void var7_13;
            DynamicRelationshipType relType = DynamicRelationshipType.withName((String)("Rel" + i));
            final CountDownLatch latch = new CountDownLatch(1);
            ArrayList<9> threads = new ArrayList<9>();
            for (int s = 0; s < slaves; ++s) {
                final GraphDatabaseAPI graphDatabaseAPI = this.getSlave(s);
                Thread thread = new Thread((RelationshipType)relType){
                    final /* synthetic */ RelationshipType val$relType;
                    {
                        this.val$relType = relationshipType;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        Transaction tx = graphDatabaseAPI.beginTx();
                        try {
                            graphDatabaseAPI.createNode().createRelationshipTo(graphDatabaseAPI.createNode(), this.val$relType);
                            tx.success();
                        }
                        finally {
                            tx.finish();
                        }
                    }
                };
                thread.start();
                threads.add(thread);
            }
            latch.countDown();
            for (Thread thread : threads) {
                thread.join();
            }
            ArrayList<Object> dbs = new ArrayList<Object>();
            dbs.add(this.getMasterHaDb());
            boolean bl = false;
            while (var7_13 < slaves) {
                dbs.add(this.getSlave((int)var7_13));
                ++var7_13;
            }
            boolean bl2 = false;
            for (GraphDatabaseAPI graphDatabaseAPI : dbs) {
                int n;
                RelationshipTypeHolder holder = graphDatabaseAPI.getNodeManager().getRelationshipTypeHolder();
                n = this.highestIdOf(holder, n);
                HashSet<String> types = new HashSet<String>();
                for (int j = 0; j <= n; ++j) {
                    RelationshipType type = holder.getRelationshipType(j);
                    if (type == null) continue;
                    Assert.assertTrue((String)(type.name() + " already existed for " + graphDatabaseAPI), (boolean)types.add(type.name()));
                }
            }
        }
        this.pullUpdates(new int[0]);
    }

    private int highestIdOf(RelationshipTypeHolder holder, int high) {
        for (RelationshipType type : holder.getRelationshipTypes()) {
            high = Math.max(holder.getIdFor(type.name()), high);
        }
        return high;
    }

    private RelationshipType getRelationshipType(GraphDatabaseAPI db, String name) {
        int id = db.getNodeManager().getRelationshipTypeHolder().getIdFor(name);
        return db.getNodeManager().getRelationshipTypeHolder().getRelationshipType(id);
    }

    private Pair<Integer, Integer> getTransactionCounts(GraphDatabaseAPI master) {
        return Pair.of((Object)((TxManager)master.getTxManager()).getCommittedTxCount(), (Object)((TxManager)master.getTxManager()).getRolledbackTxCount());
    }
}

