/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import javax.transaction.TransactionManager;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.SlaveDatabaseOperations;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.TxManager;

public class SlaveRelationshipTypeCreator
implements RelationshipTypeCreator {
    private final Broker broker;
    private final SlaveDatabaseOperations databaseOperations;

    public SlaveRelationshipTypeCreator(Broker broker, SlaveDatabaseOperations databaseOperations) {
        this.broker = broker;
        this.databaseOperations = databaseOperations;
    }

    public int getOrCreate(TransactionManager txManager, EntityIdGenerator idGenerator, PersistenceManager persistence, RelationshipTypeHolder relTypeHolder, String name) {
        try {
            int eventIdentifier = ((TxManager)txManager).getEventIdentifier();
            return this.databaseOperations.receive(((Master)this.broker.getMaster().first()).createRelationshipType(this.databaseOperations.getSlaveContext(eventIdentifier), name));
        }
        catch (RuntimeException e) {
            this.databaseOperations.exceptionHappened(e);
            throw e;
        }
    }
}

