/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.NotCompliantMBeanException;
import javax.management.remote.JMXServiceURL;
import org.neo4j.com.SlaveContext;
import org.neo4j.helpers.Format;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.AbstractHAGraphDatabase;
import org.neo4j.kernel.ha.ConnectionInformation;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.management.HighAvailability;
import org.neo4j.management.InstanceInfo;
import org.neo4j.management.SlaveInfo;

public final class HighAvailabilityBean
extends ManagementBeanProvider {
    public HighAvailabilityBean() {
        super(HighAvailability.class);
    }

    protected Neo4jMBean createMXBean(ManagementData management) throws NotCompliantMBeanException {
        if (!HighAvailabilityBean.isHA(management)) {
            return null;
        }
        return new HighAvailibilityImpl(management, true);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        if (!HighAvailabilityBean.isHA(management)) {
            return null;
        }
        return new HighAvailibilityImpl(management);
    }

    private static boolean isHA(ManagementData management) {
        return management.getKernelData().graphDatabase() instanceof AbstractHAGraphDatabase;
    }

    private static class HighAvailibilityImpl
    extends Neo4jMBean
    implements HighAvailability {
        private final HighlyAvailableGraphDatabase db;

        HighAvailibilityImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.db = ((AbstractHAGraphDatabase)management.getKernelData().graphDatabase()).getHighlyAvailableGraphDatabase();
        }

        HighAvailibilityImpl(ManagementData management, boolean isMXBean) {
            super(management, isMXBean, new String[0]);
            this.db = ((AbstractHAGraphDatabase)management.getKernelData().graphDatabase()).getHighlyAvailableGraphDatabase();
        }

        public String getMachineId() {
            return Integer.toString(this.db.getMachineId());
        }

        public InstanceInfo[] getInstancesInCluster() {
            ConnectionInformation[] connections = this.db.getBroker().getConnectionInformation();
            InstanceInfo[] result = new InstanceInfo[connections.length];
            for (int i = 0; i < result.length; ++i) {
                ConnectionInformation connection = connections[i];
                JMXServiceURL jmxServiceURL = connection.getJMXServiceURL();
                result[i] = new InstanceInfo(jmxServiceURL == null ? null : jmxServiceURL.toString(), connection.getInstanceId(), connection.getMachineId(), connection.isMaster(), connection.getLastCommitedTransactionId());
            }
            return result;
        }

        public boolean isMaster() {
            return this.db.isMaster();
        }

        public SlaveInfo[] getConnectedSlaves() {
            MasterServer master = this.db.getMasterServerIfMaster();
            if (master == null) {
                return null;
            }
            ArrayList<SlaveInfo> result = new ArrayList<SlaveInfo>();
            for (Map.Entry<Integer, Collection<SlaveContext>> entry : master.getSlaveInformation().entrySet()) {
                result.add(this.slaveInfo(entry.getKey(), entry.getValue()));
            }
            return result.toArray(new SlaveInfo[result.size()]);
        }

        public String getLastUpdateTime() {
            return Format.date((long)this.db.lastUpdateTime());
        }

        public String update() {
            long time = System.currentTimeMillis();
            try {
                this.db.pullUpdates();
            }
            catch (Exception e) {
                return "Update failed: " + e;
            }
            time = System.currentTimeMillis() - time;
            return "Update completed in " + time + "ms";
        }

        private SlaveInfo slaveInfo(int machineId, Collection<SlaveContext> contexts) {
            ArrayList<SlaveInfo.SlaveTransaction> txInfo = new ArrayList<SlaveInfo.SlaveTransaction>();
            for (SlaveContext context : contexts) {
                HashMap<String, Long> lastTransactions = new HashMap<String, Long>();
                for (SlaveContext.Tx tx : context.lastAppliedTransactions()) {
                    lastTransactions.put(tx.getDataSourceName(), tx.getTxId());
                }
                txInfo.add(new SlaveInfo.SlaveTransaction(context.getEventIdentifier(), lastTransactions));
            }
            ConnectionInformation connection = this.db.getBroker().getConnectionInformation(machineId);
            JMXServiceURL jmxServiceURL = connection.getJMXServiceURL();
            return new SlaveInfo(jmxServiceURL == null ? null : jmxServiceURL.toString(), connection.getInstanceId(), machineId, false, connection.getLastCommitedTransactionId(), txInfo.toArray(new SlaveInfo.SlaveTransaction[txInfo.size()]));
        }
    }
}

