/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.AbstractBroker;
import org.neo4j.kernel.ha.ConnectionInformation;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.shell.ZooClientFactory;
import org.neo4j.kernel.ha.zookeeper.AbstractZooKeeperManager;
import org.neo4j.kernel.ha.zookeeper.BrokerShutDownException;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.ZooClient;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperMachine;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.management.Neo4jManager;

public class ZooKeeperBroker
extends AbstractBroker {
    private final ZooClientFactory zooClientFactory;
    private volatile ZooClient zooClient;
    private int fetchInfoTimeout;

    public ZooKeeperBroker(Config conf, ZooClientFactory zooClientFactory) {
        super(conf);
        this.zooClientFactory = zooClientFactory;
        this.fetchInfoTimeout = conf.getInteger(HaSettings.coordinator_fetch_info_timeout);
        this.start();
    }

    @Override
    public void logStatus(StringLogger msgLog) {
        for (String server : this.zooClient.getServers().split(",")) {
            msgLog.logMessage(this.zkStatus(server, "conf"));
            msgLog.logMessage(this.zkStatus(server, "envi"));
            msgLog.logMessage(this.zkStatus(server, "srvr"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String zkStatus(String server, String command) {
        int port;
        StringBuilder result = new StringBuilder("ZooKeeper status: ").append(server).append(" ").append(command);
        String[] hostAndPort = server.split(":");
        if (hostAndPort.length != 2) {
            return result.append(" BAD SERVER STRING").toString();
        }
        String host = hostAndPort[0];
        try {
            port = Integer.parseInt(hostAndPort[1]);
        }
        catch (NumberFormatException e) {
            return result.append(" BAD SERVER STRING").toString();
        }
        InetSocketAddress sockAddr = new InetSocketAddress(host, port);
        try {
            Socket soc = new Socket();
            soc.connect(sockAddr, this.fetchInfoTimeout);
            BufferedReader in = new BufferedReader(new InputStreamReader(soc.getInputStream()));
            try {
                PrintWriter out = new PrintWriter(soc.getOutputStream(), true);
                try {
                    String line;
                    out.println(command);
                    while ((line = in.readLine()) != null) {
                        result.append("\n  ").append(line);
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            result.append(" FAILED: " + e);
        }
        return result.toString();
    }

    @Override
    public StoreId getClusterStoreId(boolean firstTime) {
        return this.getZooClient().getClusterStoreId(firstTime ? AbstractZooKeeperManager.WaitMode.STARTUP : AbstractZooKeeperManager.WaitMode.SESSION);
    }

    @Override
    public void setConnectionInformation(KernelData kernel) {
        String instanceId = kernel.instanceId();
        JMXServiceURL url = Neo4jManager.getConnectionURL((KernelData)kernel);
        if (instanceId != null && url != null) {
            this.getZooClient().setJmxConnectionData(url, instanceId);
        }
    }

    @Override
    public ConnectionInformation getConnectionInformation(int machineId) {
        for (ConnectionInformation connection : this.getConnectionInformation()) {
            if (connection.getMachineId() != machineId) continue;
            return connection;
        }
        return null;
    }

    @Override
    public ConnectionInformation[] getConnectionInformation() {
        Map<Integer, ZooKeeperMachine> machines = this.getZooClient().getAllMachines(false);
        ZooKeeperMachine master = this.getZooClient().getMasterBasedOn(machines.values());
        ConnectionInformation[] result = new ConnectionInformation[machines.size()];
        int i = 0;
        for (ZooKeeperMachine machine : machines.values()) {
            result[i++] = this.addJmxInfo(new ConnectionInformation(machine, master.equals(machine)));
        }
        return result;
    }

    private ConnectionInformation addJmxInfo(ConnectionInformation connect) {
        this.getZooClient().getJmxConnectionData(connect);
        return connect;
    }

    @Override
    public Pair<Master, Machine> getMaster() {
        return this.getZooClient().getCachedMaster();
    }

    @Override
    public Pair<Master, Machine> getMasterReally(boolean allowChange) {
        return this.getZooClient().getMasterFromZooKeeper(true, allowChange);
    }

    @Override
    public Machine getMasterExceptMyself() {
        Map<Integer, ZooKeeperMachine> machines = this.getZooClient().getAllMachines(true);
        machines.remove(this.getMyMachineId());
        return this.getZooClient().getMasterBasedOn(machines.values());
    }

    @Override
    public Object instantiateMasterServer(GraphDatabaseAPI graphDb) {
        return this.zooClient.instantiateMasterServer(graphDb);
    }

    @Override
    public void setLastCommittedTxId(long txId) {
        this.getZooClient().setCommittedTx(txId);
    }

    @Override
    public boolean iAmMaster() {
        return ((Machine)this.getZooClient().getCachedMaster().other()).getMachineId() == this.getMyMachineId();
    }

    @Override
    public synchronized void start() {
        if (this.zooClient != null) {
            throw new IllegalStateException("Broker already started, ZooClient is " + this.zooClient);
        }
        this.zooClient = this.zooClientFactory.newZooClient();
    }

    @Override
    public synchronized void shutdown() {
        if (this.zooClient == null) {
            throw new IllegalStateException("Broker already shutdown");
        }
        this.zooClient.shutdown();
        this.zooClient = null;
    }

    @Override
    public synchronized void restart() {
        this.shutdown();
        this.start();
    }

    @Override
    public void rebindMaster() {
        this.getZooClient().setDataChangeWatcher("master-rebound", this.getMyMachineId());
    }

    @Override
    public void notifyMasterChange(Machine newMaster) {
        this.getZooClient().setDataChangeWatcher("master-notify", newMaster.getMachineId());
    }

    protected ZooClient getZooClient() {
        if (this.zooClient == null) {
            throw new BrokerShutDownException();
        }
        return this.zooClient;
    }

    @Override
    public Pair<Master, Machine> bootstrap() {
        return this.getZooClient().bootstrap();
    }
}

