/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.GCResistantCache;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.util.StringLogger;

public class GCResistantCacheProvider
extends CacheProvider {
    public static final String NAME = "gcr";

    public GCResistantCacheProvider() {
        super(NAME, "GC resistant cache");
    }

    public Cache<NodeImpl> newNodeCache(StringLogger logger, Config config) {
        long available = Runtime.getRuntime().maxMemory();
        long defaultMem = available / 4L;
        long node = config.isSet((GraphDatabaseSetting)GraphDatabaseSettings.node_cache_size) ? config.getSize(GraphDatabaseSettings.node_cache_size) : defaultMem;
        long rel = config.isSet((GraphDatabaseSetting)GraphDatabaseSettings.relationship_cache_size) ? config.getSize(GraphDatabaseSettings.relationship_cache_size) : defaultMem;
        this.checkMemToUse(logger, node, rel, available);
        return new GCResistantCache<NodeImpl>(node, config.getFloat(GraphDatabaseSettings.node_cache_array_fraction), config.getDuration(GraphDatabaseSettings.gcr_cache_min_log_interval), "NodeCache", logger);
    }

    public Cache<RelationshipImpl> newRelationshipCache(StringLogger logger, Config config) {
        long available = Runtime.getRuntime().maxMemory();
        long defaultMem = available / 4L;
        long node = config.isSet((GraphDatabaseSetting)GraphDatabaseSettings.node_cache_size) ? config.getSize(GraphDatabaseSettings.node_cache_size) : defaultMem;
        long rel = config.isSet((GraphDatabaseSetting)GraphDatabaseSettings.relationship_cache_size) ? config.getSize(GraphDatabaseSettings.relationship_cache_size) : defaultMem;
        this.checkMemToUse(logger, node, rel, available);
        return new GCResistantCache<RelationshipImpl>(rel, config.getFloat(GraphDatabaseSettings.relationship_cache_array_fraction), config.getDuration(GraphDatabaseSettings.gcr_cache_min_log_interval), "RelationshipCache", logger);
    }

    private void checkMemToUse(StringLogger logger, long node, long rel, long available) {
        long advicedMax = available / 2L;
        long total = 0L;
        node = Math.max(1L, node);
        total += node;
        if ((total += (rel = Math.max(1L, rel))) > available) {
            throw new IllegalArgumentException(String.format("Configured cache memory limits (node=%s, relationship=%s, total=%s) exceeds available heap space (%s)", node, rel, total, available));
        }
        if (total > advicedMax) {
            logger.logMessage(String.format("Configured cache memory limits(node=%s, relationship=%s, total=%s) exceeds recommended limit (%s)", node, rel, total, advicedMax));
        }
    }
}

