/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.QuorumMXBean;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.junit.Ignore;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.Predicate;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.SubProcess;

@Ignore
public final class LocalhostZooKeeperCluster {
    private static LocalhostZooKeeperCluster SINGLETON;
    private final String connection;
    private volatile ZooKeeperMember[] keeper;
    private final int[] ports;
    private final TargetDirectory target;

    public static synchronized LocalhostZooKeeperCluster singleton() {
        if (SINGLETON == null) {
            SINGLETON = LocalhostZooKeeperCluster.standardZoo(LocalhostZooKeeperCluster.class);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    SINGLETON.shutdown();
                }
            });
        }
        return SINGLETON;
    }

    public LocalhostZooKeeperCluster(Class<?> owningTest, int ... ports) {
        this(TargetDirectory.forTest(owningTest), ports);
    }

    public LocalhostZooKeeperCluster(TargetDirectory target, int ... ports) {
        this.target = target;
        this.ports = ports;
        this.connection = this.formConnectionString(ports);
        this.instantiateQuorumWithRetry();
    }

    private void instantiateQuorumWithRetry() {
        Exception error = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.instantiateQuorum();
                return;
            }
            catch (Exception e) {
                System.out.println("ZK connection couldn't be verified, retrying...");
                error = e;
                continue;
            }
        }
        throw new RuntimeException("Couldn't form a ZK quorum even after a couple of retries", error);
    }

    private String formConnectionString(int ... ports) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < ports.length; ++i) {
            builder.append(i > 0 ? "," : "").append("localhost:" + ports[i]);
        }
        return builder.toString();
    }

    private void instantiateQuorum() {
        this.keeper = new ZooKeeperMember[this.ports.length];
        boolean success = false;
        try {
            ZooKeeperProcess subprocess = new ZooKeeperProcess(null);
            for (int i = 0; i < this.keeper.length; ++i) {
                this.keeper[i] = (ZooKeeperMember)subprocess.start(new String[]{this.config(this.target, i + 1, this.ports[i])}, new BreakPoint[0]);
            }
            this.verify(null);
            success = true;
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
        finally {
            if (!success) {
                this.shutdown();
            }
        }
    }

    public LocalhostZooKeeperCluster clearDataAndVerifyConnection() throws Exception {
        try {
            this.verify(new ZooKeeperJob(){

                @Override
                public void run(ZooKeeper client) throws Exception {
                    for (String child : client.getChildren("/", false)) {
                        if (child.equals("zookeeper")) continue;
                        this.deleteRecursively(client, "/" + child);
                    }
                }

                private void deleteRecursively(ZooKeeper client, String path) throws Exception {
                    List children = client.getChildren(path, false);
                    if (children != null && !children.isEmpty()) {
                        for (String child : children) {
                            this.deleteRecursively(client, path + "/" + child);
                        }
                    }
                    client.delete(path, -1);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.shutdown();
            this.instantiateQuorumWithRetry();
        }
        return this;
    }

    public static LocalhostZooKeeperCluster standardZoo(Class<?> owningTest) {
        return new LocalhostZooKeeperCluster(owningTest, 2181, 2182, 2183);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verify(ZooKeeperJob job) throws Exception {
        ZooKeeperAccess verifier = new ZooKeeperAccess(job);
        try {
            verifier.awaitSyncConnected(15000L);
        }
        finally {
            verifier.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getConnectionString() + "]";
    }

    public synchronized String getConnectionString() {
        return this.connection;
    }

    String getStatus() {
        StringBuilder result = new StringBuilder();
        String prefix = "";
        for (ZooKeeperMember zk : this.keeper) {
            result.append(prefix).append(zk).append(": ").append(zk.getStatus());
            prefix = "; ";
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String config(TargetDirectory target, int id, int port) {
        File config = target.file("zookeeper" + id + ".cfg");
        File dataDir = target.directory("zk" + id + "data", true);
        try {
            PrintWriter conf = new PrintWriter(config);
            try {
                conf.println("tickTime=2000");
                conf.println("initLimit=10");
                conf.println("syncLimit=5");
                conf.println("maxClientCnxns=50");
                conf.println("dataDir=" + dataDir.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\"));
                conf.println("clientPort=" + port);
                for (int j = 0; j < this.keeper.length; ++j) {
                    conf.println("server." + (j + 1) + "=localhost:" + (2888 + j) + ":" + (3888 + j));
                }
            }
            finally {
                conf.close();
            }
            PrintWriter myid = new PrintWriter(new File(dataDir, "myid"));
            try {
                myid.println(Integer.toString(id));
            }
            finally {
                myid.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write ZooKeeper configuration", e);
        }
        return config.getAbsolutePath();
    }

    public synchronized void shutdown() {
        if (this.keeper.length > 0 && this.keeper[0] == null) {
            return;
        }
        Thread[] stopperThreads = new Thread[this.keeper.length];
        for (int i = 0; i < this.keeper.length; ++i) {
            final ZooKeeperMember member = this.keeper[i];
            stopperThreads[i] = new Thread(){

                @Override
                public void run() {
                    if (member != null) {
                        SubProcess.stop((Object)member);
                    }
                }
            };
            stopperThreads[i].start();
        }
        for (Thread thread : stopperThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        Arrays.fill(this.keeper, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        LocalhostZooKeeperCluster cluster = LocalhostZooKeeperCluster.standardZoo(LocalhostZooKeeperCluster.class);
        try {
            System.out.println("Press return to exit");
            System.in.read();
            System.out.println("Shutting down cluster");
        }
        finally {
            cluster.shutdown();
        }
    }

    private static class ZooKeeperProcess
    extends SubProcess<ZooKeeperMember, String[]>
    implements ZooKeeperMember {
        private final String name;

        ZooKeeperProcess(String name) {
            super((Predicate)new Predicate<String>(){

                public boolean accept(String item) {
                    return !item.contains("slf4j");
                }
            });
            this.name = name;
        }

        protected void startup(String[] parameters) {
            System.out.println("parameters=" + Arrays.toString(parameters));
            QuorumPeerMain.main((String[])parameters);
        }

        public String toString() {
            if (this.name != null) {
                return super.toString() + ":" + this.name;
            }
            return super.toString();
        }

        @Override
        public int getQuorumSize() {
            try {
                return this.quorumBean().getQuorumSize();
            }
            catch (Exception e) {
                return 0;
            }
        }

        @Override
        public String getStatus() {
            try {
                return this.status(this.quorumBean());
            }
            catch (Exception e) {
                return "-down-";
            }
        }

        private QuorumMXBean quorumBean() throws MalformedObjectNameException {
            Set<ObjectName> names = ManagementFactory.getPlatformMBeanServer().queryNames(new ObjectName("org.apache.ZooKeeperService:name0=ReplicatedServer_id*"), null);
            QuorumMXBean quorum = MBeanServerInvocationHandler.newProxyInstance(ManagementFactory.getPlatformMBeanServer(), names.iterator().next(), QuorumMXBean.class, false);
            return quorum;
        }

        private String status(QuorumMXBean quorumBean) {
            long time = System.currentTimeMillis();
            String name = quorumBean.getName();
            int size = quorumBean.getQuorumSize();
            return String.format("name=%s, size=%s, time=%s (+%sms)", name, size, Format.time((long)time), System.currentTimeMillis() - time);
        }
    }

    public static interface ZooKeeperMember {
        public int getQuorumSize();

        public String getStatus();
    }

    private static interface ZooKeeperJob {
        public void run(ZooKeeper var1) throws Exception;
    }

    private class ZooKeeperAccess
    implements Watcher {
        private final ZooKeeper keeper;
        private volatile boolean connected;
        private final ZooKeeperJob executeOnSyncConnected;

        ZooKeeperAccess(ZooKeeperJob executeOnSyncConnected) throws IOException {
            this.executeOnSyncConnected = executeOnSyncConnected;
            this.keeper = new ZooKeeper(LocalhostZooKeeperCluster.this.connection, 5000, (Watcher)this);
        }

        public synchronized void process(WatchedEvent event) {
            switch (event.getState()) {
                case SyncConnected: {
                    this.connected = true;
                    this.notify();
                    break;
                }
                default: {
                    this.connected = false;
                }
            }
        }

        public void close() throws Exception {
            this.keeper.close();
        }

        public synchronized void awaitSyncConnected(long timeout) throws Exception {
            if (!this.connected) {
                this.wait(timeout);
                if (this.connected && this.executeOnSyncConnected != null) {
                    this.keeper.sync("/", null, null);
                    this.executeOnSyncConnected.run(this.keeper);
                }
            }
            if (!this.connected) {
                throw new RuntimeException("Connection not valid");
            }
        }
    }
}

