/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.Before;
import org.junit.Ignore;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;
import org.neo4j.test.ha.StandaloneDatabase;
import slavetest.Job;
import slavetest.MultiJvmTest;

@Ignore(value="Too unstable to have as unit tests. The HA Cronies will make sure the ZooKeeper aspect of HA is working correctly")
public class MultiJvmWithZooKeeperTest
extends MultiJvmTest {
    private static final File BASE_ZOO_KEEPER_DATA_DIR = new File(new File("target"), "zookeeper-data");
    private static final int BASE_HA_SERVER_PORT = 5559;
    private static LocalhostZooKeeperCluster zooKeeperCluster;
    private final Map<Integer, StandaloneDatabase> jvmByMachineId = new HashMap<Integer, StandaloneDatabase>();

    @Before
    public void startZooKeeperCluster() throws Exception {
        FileUtils.deleteDirectory((File)BASE_ZOO_KEEPER_DATA_DIR);
        zooKeeperCluster = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
    }

    @Override
    protected void initializeDbs(int numSlaves, Map<String, String> config) throws Exception {
        super.initializeDbs(numSlaves, config);
        for (StandaloneDatabase db : this.jvmByMachineId.values()) {
            db.awaitStarted();
        }
    }

    @Override
    protected StandaloneDatabase spawnJvm(File path, int machineId, String ... extraArgs) throws Exception {
        StandaloneDatabase db = StandaloneDatabase.withDefaultBroker(this.testName.getMethodName(), path.getAbsoluteFile(), machineId, zooKeeperCluster, MultiJvmWithZooKeeperTest.buildHaServerConfigValue(machineId), extraArgs);
        this.jvmByMachineId.put(machineId + 1, db);
        return db;
    }

    private static String buildHaServerConfigValue(int machineId) {
        return "localhost:" + (5559 + machineId);
    }

    @Override
    protected <T> T executeJobOnMaster(Job<T> job) throws Exception {
        return this.jvmByMachineId.get(1).executeJob(job);
    }
}

