/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import org.junit.Ignore;
import org.junit.Test;
import slavetest.AbstractHaTest;
import slavetest.CommonJobs;
import slavetest.Job;
import slavetest.MultiJvmTest;
import slavetest.MultiJvmWithZooKeeperTest;
import slavetest.SingleJvmTest;

@Ignore
public class PerformanceTest {
    private boolean selective = false;

    @Test
    public void allocateIds() throws Exception {
        this.testJob(new CommonJobs.PerformanceIdAllocationJob(1000000));
    }

    @Test
    public void createFewNodesInManyTransactions() throws Exception {
        this.testJob(new CommonJobs.PerformanceCreateNodesJob(10, 100));
    }

    @Test
    public void createManyNodesInFewTransactions() throws Exception {
        this.testJob(new CommonJobs.PerformanceCreateNodesJob(10, 1000));
    }

    @Test
    public void grabLocks() throws Exception {
        this.testJob(new CommonJobs.PerformanceAcquireWriteLocksJob(10000));
    }

    public static void main(String[] args) throws Exception {
        PerformanceTest perf = new PerformanceTest();
        perf.selective = true;
        for (String test : args) {
            PerformanceTest.class.getDeclaredMethod(test, new Class[0]).invoke((Object)perf, new Object[0]);
        }
    }

    private void testJob(Job<Void> job) throws Exception {
        boolean noHa = this.doTest("NO_HA");
        boolean singleJvm = this.doTest("SINGLE_JVM");
        if (noHa || singleJvm) {
            SingleJvmTest single = new SingleJvmTest();
            if (noHa) {
                single.initializeDbs(1);
                this.time("No HA", this.executeOnMaster(single, job));
                ((AbstractHaTest)single).shutdownDbs();
            }
            if (singleJvm) {
                single.initializeDbs(1);
                this.time("Single JVM HA", this.executeOnSlave(single, job));
                ((AbstractHaTest)single).shutdownDbs();
            }
        }
        if (this.doTest("MULTI_JVM")) {
            MultiJvmTest multi = new MultiJvmTest();
            multi.initializeDbs(1);
            this.time("Multi JVM HA", this.executeOnSlave(multi, job));
            multi.shutdownDbs();
        }
        if (this.doTest("FULL_HA")) {
            MultiJvmWithZooKeeperTest multiZoo = new MultiJvmWithZooKeeperTest();
            multiZoo.startZooKeeperCluster();
            multiZoo.initializeDbs(1);
            this.time("Multi JVM HA with ZooKeeper", this.executeOnSlave(multiZoo, job));
            multiZoo.shutdownDbs();
        }
    }

    private boolean doTest(String testName) {
        if (this.selective) {
            return Boolean.getBoolean("org.neo4j.ha.test." + testName);
        }
        return true;
    }

    private Runnable executeOnSlave(final AbstractHaTest test, final Job<Void> job) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    test.executeJob(job, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private Runnable executeOnMaster(final AbstractHaTest test, final Job<Void> job) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    test.executeJobOnMaster(job);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    protected void time(String message, Runnable runnable) {
        long t = System.currentTimeMillis();
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        long time = System.currentTimeMillis() - t;
        System.out.println(message + ": " + time + "ms");
    }
}

