/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.backup;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.zookeeper.KeeperException;
import org.neo4j.backup.BackupExtensionService;
import org.neo4j.com.ComException;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperClusterClient;

public final class HaBackupProvider
extends BackupExtensionService {
    private static final String ServerAddressFormat = "ha://%s:%d";

    public HaBackupProvider() {
        super("ha");
    }

    public URI resolve(URI address, Args args) {
        String master = null;
        try {
            System.out.println("Asking coordinator service at '" + address + "' for master");
            String clusterName = args.get(HaSettings.cluster_name.name(), null);
            if (clusterName == null) {
                clusterName = args.get("cluster", ConfigurationDefaults.getDefault((GraphDatabaseSetting)HaSettings.cluster_name, HaSettings.class));
            }
            master = HaBackupProvider.getMasterServerInCluster(address.getSchemeSpecificPart().substring(2), clusterName);
            System.out.println("Found master '" + master + "' in cluster");
        }
        catch (ComException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof KeeperException) {
                KeeperException zkException = (KeeperException)e.getCause();
                System.out.println("Couldn't connect to '" + address + "', " + zkException.getMessage());
            }
            throw e;
        }
        URI toReturn = null;
        try {
            toReturn = new URI(master);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        return toReturn;
    }

    private static String getMasterServerInCluster(String from, String clusterName) {
        ZooKeeperClusterClient clusterClient = new ZooKeeperClusterClient(from, clusterName);
        Pair<String, Integer> masterServer = null;
        try {
            clusterClient.waitForSyncConnected();
            Machine master = clusterClient.getMaster();
            masterServer = master.getServer();
            if (masterServer != null) {
                int backupPort = clusterClient.getBackupPort(master.getMachineId());
                String string = String.format(ServerAddressFormat, masterServer.first(), backupPort);
                return string;
            }
            throw new ComException("Master couldn't be found from cluster managed by " + from);
        }
        finally {
            clusterClient.shutdown();
        }
    }
}

