/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.ha.ClusterEventReceiver;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.MasterClientFactory;
import org.neo4j.kernel.ha.MasterClientResolver;
import org.neo4j.kernel.ha.zookeeper.AbstractZooKeeperManager;
import org.neo4j.kernel.ha.zookeeper.ZooClient;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperTimedOutException;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestZooClient {
    private static final ClusterEventReceiver DummyClusterReceiver = new ClusterEventReceiver(){

        public void reconnect(Exception cause) {
            StringLogger.SYSTEM.logMessage("reconnect called", (Throwable)cause);
        }

        public void newMaster(Exception cause) {
            StringLogger.SYSTEM.logMessage("newMaster called", (Throwable)cause);
        }
    };

    @Test
    public void testWaitsForZKQuorumToComeUp() throws Exception {
        long millisForSessionToExpire = 1000L;
        HashMap<String, String> stringConfig = new HashMap<String, String>();
        stringConfig.put(HaSettings.coordinators.name(), "127.0.0.1:3181");
        stringConfig.put(HaSettings.server_id.name(), "1");
        stringConfig.put(HaSettings.zk_session_timeout.name(), Long.toString(1000L));
        Config config = new Config(new ConfigurationDefaults(new Class[]{OnlineBackupSettings.class, GraphDatabaseSettings.class, HaSettings.class}).apply(stringConfig));
        ZooClient client = new ZooClient("", StringLogger.SYSTEM, config, null, DummyClusterReceiver, (MasterClientFactory)new MasterClientResolver.F18(StringLogger.SYSTEM, 20, 20, 20));
        final AtomicBoolean stop = new AtomicBoolean(false);
        Thread launchesZK = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LocalhostZooKeeperCluster cluster = null;
                try {
                    Thread.sleep(2000L);
                    cluster = new LocalhostZooKeeperCluster(this.getClass(), 3181);
                    while (!stop.get()) {
                        Thread.sleep(150L);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                finally {
                    if (cluster != null) {
                        cluster.shutdown();
                    }
                }
            }
        });
        launchesZK.setDaemon(true);
        launchesZK.start();
        client.waitForSyncConnected(AbstractZooKeeperManager.WaitMode.STARTUP);
        client.shutdown();
        stop.set(true);
        launchesZK.join();
    }

    @Test
    public void sessionWaitSyncConnectedTimesOut() throws Exception {
        long secondsForSessionToExpire = 1L;
        HashMap<String, String> stringConfig = new HashMap<String, String>();
        stringConfig.put(HaSettings.coordinators.name(), "localhost:4181");
        stringConfig.put(HaSettings.server_id.name(), "1");
        stringConfig.put(HaSettings.zk_session_timeout.name(), Long.toString(1000L));
        Config config = new Config(new ConfigurationDefaults(new Class[]{OnlineBackupSettings.class, GraphDatabaseSettings.class, HaSettings.class}).apply(stringConfig));
        ZooClient client = new ZooClient("", StringLogger.SYSTEM, config, null, DummyClusterReceiver, (MasterClientFactory)new MasterClientResolver.F18(StringLogger.SYSTEM, 20, 20, 20));
        final Thread me = Thread.currentThread();
        final AtomicBoolean allOk = new AtomicBoolean(false);
        Thread wakeMeUp = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    if (!allOk.get()) {
                        me.interrupt();
                    }
                }
                catch (Exception e) {
                    if (!allOk.get()) {
                        throw new RuntimeException(e);
                    }
                    Thread.interrupted();
                }
            }
        });
        wakeMeUp.setDaemon(true);
        wakeMeUp.start();
        try {
            client.waitForSyncConnected();
            Assert.fail((String)"There is no zookeeper here, it should time out within a session timeout");
        }
        catch (ZooKeeperTimedOutException success) {
            allOk.set(true);
        }
        wakeMeUp.interrupt();
        wakeMeUp.join();
        client.shutdown();
    }
}

