/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Ignore;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.ClusterClient;
import org.neo4j.kernel.ha.FakeClusterClient;
import org.neo4j.kernel.ha.FakeMasterBroker;
import org.neo4j.kernel.ha.FakeSlaveBroker;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterImpl;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.test.BatchTransaction;
import slavetest.AbstractHaTest;
import slavetest.CommonJobs;
import slavetest.DoubleLatch;
import slavetest.Fetcher;
import slavetest.Job;
import slavetest.TestMaster;

@Ignore(value="SingleJvmWithNettyTest covers this and more")
public class SingleJvmTest
extends AbstractHaTest {
    private TestMaster master;
    private List<GraphDatabaseAPI> haDbs;
    protected FakeMasterBroker masterBroker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void verifyAndShutdownDbs() {
        try {
            this.verify((GraphDatabaseService)this.master.getGraphDb(), this.haDbs.toArray(new GraphDatabaseService[this.haDbs.size()]));
        }
        finally {
            this.shutdownDbs();
        }
        if (!this.shouldDoVerificationAfterTests()) {
            return;
        }
        EmbeddedGraphDatabase masterOfflineDb = new EmbeddedGraphDatabase(this.dbPath(0).getAbsolutePath());
        GraphDatabaseService[] slaveOfflineDbs = new GraphDatabaseService[this.haDbs.size()];
        for (int i = 1; i <= this.haDbs.size(); ++i) {
            slaveOfflineDbs[i - 1] = new EmbeddedGraphDatabase(this.dbPath(i).getAbsolutePath());
        }
        try {
            this.verify((GraphDatabaseService)masterOfflineDb, slaveOfflineDbs);
        }
        finally {
            masterOfflineDb.shutdown();
            for (GraphDatabaseService db : slaveOfflineDbs) {
                db.shutdown();
            }
        }
    }

    protected GraphDatabaseAPI getSlave(int nr) {
        return this.haDbs.get(nr);
    }

    @Override
    protected int addDb(Map<String, String> config, boolean awaitStarted) {
        this.haDbs = this.haDbs != null ? this.haDbs : new ArrayList<GraphDatabaseAPI>();
        int machineId = this.haDbs.size() + 1;
        this.haDbs.add(null);
        GraphDatabaseAPI db = this.startDb(machineId, config, awaitStarted);
        return machineId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createBigMasterStore(int numberOfMegabytes) {
        GraphDatabaseAPI db = this.getMaster().getGraphDb();
        BatchTransaction tx = BatchTransaction.beginBatchTx((GraphDatabaseService)db);
        try {
            byte[] array = new byte[100000];
            for (int i = 0; i < numberOfMegabytes * 10; ++i) {
                Node node = db.createNode();
                node.setProperty("array", (Object)array);
                tx.increment();
            }
        }
        finally {
            tx.finish();
        }
    }

    @Override
    protected GraphDatabaseAPI startDb(final int machineId, Map<String, String> config, boolean awaitStarted) {
        this.haDbs = this.haDbs != null ? this.haDbs : new ArrayList<GraphDatabaseAPI>();
        File slavePath = this.dbPath(machineId);
        final HashMap<String, String> cfg = new HashMap<String, String>(config);
        cfg.put(HaSettings.server_id.name(), Integer.toString(machineId));
        cfg.put(GraphDatabaseSettings.keep_logical_logs.name(), "true");
        this.addDefaultConfig(cfg);
        HighlyAvailableGraphDatabase haGraphDb = new HighlyAvailableGraphDatabase(slavePath.getAbsolutePath(), cfg, Service.load(IndexProvider.class), Service.load(KernelExtension.class), Service.load(CacheProvider.class)){

            protected Broker createBroker() {
                return SingleJvmTest.this.makeSlaveBroker(SingleJvmTest.this.master, 0, machineId, this, cfg);
            }

            protected ClusterClient createClusterClient() {
                return SingleJvmTest.this.makeMasterClusterClientFromBroker(this.getBroker());
            }
        };
        this.haDbs.set(machineId - 1, (GraphDatabaseAPI)haGraphDb);
        return haGraphDb;
    }

    @Override
    protected void awaitAllStarted() throws Exception {
    }

    @Override
    protected void shutdownDb(int machineId) {
        this.haDbs.get(machineId - 1).shutdown();
    }

    @Override
    protected void startUpMaster(Map<String, String> extraConfig) throws Exception {
        int timeOut = Integer.parseInt((extraConfig = new ConfigurationDefaults(new Class[]{HaSettings.class}).apply(extraConfig)).containsKey(HaSettings.lock_read_timeout.name()) ? (String)extraConfig.get(HaSettings.lock_read_timeout.name()) : (String)extraConfig.get(HaSettings.read_timeout.name()));
        HighlyAvailableGraphDatabase db = this.startUpMasterDb(extraConfig);
        this.master = new TestMaster((Master)new MasterImpl((GraphDatabaseAPI)db, timeOut), (GraphDatabaseAPI)db);
    }

    protected HighlyAvailableGraphDatabase startUpMasterDb(Map<String, String> extraConfig) throws Exception {
        boolean masterId = false;
        final Map config = MapUtil.stringMap(extraConfig, (String[])new String[]{HaSettings.server_id.name(), String.valueOf(0)});
        this.addDefaultConfig(config);
        String path = this.dbPath(0).getAbsolutePath();
        HighlyAvailableGraphDatabase haGraphDb = new HighlyAvailableGraphDatabase(path, config, Service.load(IndexProvider.class), Service.load(KernelExtension.class), Service.load(CacheProvider.class)){

            protected Broker createBroker() {
                SingleJvmTest.this.masterBroker = SingleJvmTest.this.makeMasterBroker(0, (GraphDatabaseAPI)this, config);
                return SingleJvmTest.this.masterBroker;
            }

            protected ClusterClient createClusterClient() {
                return SingleJvmTest.this.makeMasterClusterClientFromBroker(this.getBroker());
            }
        };
        return haGraphDb;
    }

    protected FakeMasterBroker makeMasterBroker(int masterId, GraphDatabaseAPI graphDb, Map<String, String> config) {
        config = new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class, HaSettings.class}).apply(config);
        Config configuration = new Config(config);
        return new FakeMasterBroker(configuration);
    }

    protected Broker makeSlaveBroker(TestMaster master, int masterId, int id, HighlyAvailableGraphDatabase graphDb, Map<String, String> config) {
        config = new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class, HaSettings.class}).apply(config);
        Config configuration = new Config(config);
        return new FakeSlaveBroker(master, masterId, configuration);
    }

    protected ClusterClient makeMasterClusterClientFromBroker(Broker broker) {
        return new FakeClusterClient(broker);
    }

    protected TestMaster getMaster() {
        return this.master;
    }

    @Override
    protected void shutdownDbs() {
        if (this.haDbs != null) {
            for (GraphDatabaseAPI haDb : this.haDbs) {
                haDb.shutdown();
            }
        }
        this.shutdownMaster();
    }

    @Override
    protected <T> T executeJob(Job<T> job, int slave) throws Exception {
        return job.execute(this.haDbs.get(slave));
    }

    @Override
    protected <T> T executeJobOnMaster(Job<T> job) throws Exception {
        return job.execute(this.master.getGraphDb());
    }

    @Override
    protected void pullUpdates(int ... ids) {
        if (ids.length == 0) {
            for (GraphDatabaseAPI db : this.haDbs) {
                ((HighlyAvailableGraphDatabase)db).pullUpdates();
            }
        } else {
            for (int id : ids) {
                ((HighlyAvailableGraphDatabase)this.haDbs.get(id)).pullUpdates();
            }
        }
    }

    @Override
    protected CommonJobs.ShutdownDispatcher getMasterShutdownDispatcher() {
        return new CommonJobs.ShutdownDispatcher(){

            @Override
            public void doShutdown() {
                SingleJvmTest.this.shutdownMaster();
            }
        };
    }

    @Override
    protected Fetcher<DoubleLatch> getDoubleLatch() {
        return new Fetcher<DoubleLatch>(){
            private final DoubleLatch latch = new DoubleLatch(){
                private final CountDownLatch first = new CountDownLatch(1);
                private final CountDownLatch second = new CountDownLatch(1);

                @Override
                public void countDownSecond() {
                    this.second.countDown();
                }

                @Override
                public void countDownFirst() {
                    this.first.countDown();
                }

                @Override
                public void awaitSecond() {
                    this.await(this.second);
                }

                @Override
                public void awaitFirst() {
                    this.await(this.first);
                }

                private void await(CountDownLatch latch) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        e.printStackTrace();
                    }
                }
            };

            @Override
            public DoubleLatch fetch() {
                return this.latch;
            }

            @Override
            public void close() {
            }
        };
    }

    protected void shutdownMaster() {
        this.getMasterHaDb().shutdown();
        this.getMaster().shutdown();
    }

    protected HighlyAvailableGraphDatabase getMasterHaDb() {
        return (HighlyAvailableGraphDatabase)this.getMaster().getGraphDb();
    }
}

