/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.kernel.EnterpriseGraphDatabaseFactory;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestStoreCopy {
    private static LocalhostZooKeeperCluster zoo;
    private HighlyAvailableGraphDatabase master;
    private HighlyAvailableGraphDatabase slave;
    private File slaveDir;
    private File sandboxed;
    private long nodeId;

    @BeforeClass
    public static void startZoo() throws Exception {
        zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
    }

    @Before
    public void setupMachinesAndSanityCheck() throws Exception {
        this.slaveDir = TargetDirectory.forTest(TestStoreCopy.class).directory("slave-sandboxed", true);
        this.sandboxed = new File(this.slaveDir, "temp-copy");
        this.master = (HighlyAvailableGraphDatabase)new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(TargetDirectory.forTest(TestStoreCopy.class).directory("master-sandboxed", true).getAbsolutePath()).setConfig((GraphDatabaseSetting)HaSettings.coordinators, zoo.getConnectionString()).setConfig((GraphDatabaseSetting)HaSettings.server_id, "1").setConfig((GraphDatabaseSetting)HaSettings.server, "localhost:6361").newGraphDatabase();
        Transaction masterTx = this.master.beginTx();
        Node n = this.master.createNode();
        n.setProperty("foo", (Object)"bar");
        this.nodeId = n.getId();
        masterTx.success();
        masterTx.finish();
        this.startSlave();
        Assert.assertEquals((long)1L, (long)((Machine)this.master.getBroker().getMaster().other()).getMachineId());
        Assert.assertEquals((long)1L, (long)((Machine)this.slave.getBroker().getMaster().other()).getMachineId());
        Assert.assertEquals((Object)"bar", (Object)this.slave.getNodeById(this.nodeId).getProperty("foo"));
    }

    private void startSlave() {
        this.slave = (HighlyAvailableGraphDatabase)new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.slaveDir.getAbsolutePath()).setConfig((GraphDatabaseSetting)HaSettings.coordinators, zoo.getConnectionString()).setConfig((GraphDatabaseSetting)HaSettings.server_id, "2").setConfig((GraphDatabaseSetting)HaSettings.server, "localhost:6362").newGraphDatabase();
    }

    @After
    public void shutdownAndCheckSandbox() throws Exception {
        this.slave.shutdown();
        this.master.shutdown();
        Assert.assertTrue((boolean)this.sandboxed.exists());
        Assert.assertTrue((boolean)this.sandboxed.isDirectory());
        Assert.assertEquals((long)1L, (long)this.sandboxed.listFiles().length);
        Assert.assertEquals((Object)"messages.log", (Object)this.sandboxed.listFiles()[0].getName());
    }

    @Test
    public void sandboxIsOverwritten() throws Exception {
        this.slave.shutdown();
        Transaction secondMasterTx = this.master.beginTx();
        Node n = this.master.getNodeById(this.nodeId);
        n.setProperty("foo2", (Object)"bar2");
        secondMasterTx.success();
        secondMasterTx.finish();
        File sandboxed = new File(this.slaveDir, "temp-copy");
        FileUtils.moveToDirectory((File)new File(this.slaveDir, "neostore"), (File)sandboxed, (boolean)false);
        FileUtils.moveToDirectory((File)new File(this.slaveDir, "neostore.propertystore.db"), (File)sandboxed, (boolean)false);
        Assert.assertEquals((long)3L, (long)sandboxed.listFiles().length);
        this.startSlave();
        Assert.assertEquals((Object)"bar", (Object)this.slave.getNodeById(this.nodeId).getProperty("foo"));
        Assert.assertEquals((Object)"bar2", (Object)this.slave.getNodeById(this.nodeId).getProperty("foo2"));
    }
}

