/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.kernel.EnterpriseGraphDatabaseFactory;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.BreakpointHandler;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.EnabledBreakpoints;
import org.neo4j.test.subprocess.ForeignBreakpoints;
import org.neo4j.test.subprocess.SubProcessTestRunner;

@ForeignBreakpoints(value={@ForeignBreakpoints.BreakpointDef(type="org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager", method="applyCommittedTransaction", on=BreakPoint.Event.ENTRY)})
@RunWith(value=SubProcessTestRunner.class)
@Ignore
public class TestPartialPullUpdates {
    private static LocalhostZooKeeperCluster zoo;
    private HighlyAvailableGraphDatabase master;
    private HighlyAvailableGraphDatabase slave1;

    @BeforeClass
    public static void startZoo() throws Exception {
        zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
    }

    @Before
    public void setup() throws Exception {
        this.master = (HighlyAvailableGraphDatabase)new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(TargetDirectory.forTest(TestPartialPullUpdates.class).directory("master", true).getAbsolutePath()).setConfig((GraphDatabaseSetting)HaSettings.coordinators, zoo.getConnectionString()).setConfig((GraphDatabaseSetting)HaSettings.server_id, "1").setConfig((GraphDatabaseSetting)HaSettings.tx_push_factor, "0").newGraphDatabase();
        Transaction tx = this.master.beginTx();
        Node node = this.master.createNode();
        node.setProperty("uuid", (Object)"123");
        this.master.index().forNodes("auto").add((PropertyContainer)node, "uuid", (Object)"123");
        tx.success();
        tx.finish();
        this.slave1 = (HighlyAvailableGraphDatabase)new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(TargetDirectory.forTest(TestPartialPullUpdates.class).directory("slave1", true).getAbsolutePath()).setConfig((GraphDatabaseSetting)HaSettings.coordinators, zoo.getConnectionString()).setConfig((GraphDatabaseSetting)HaSettings.server_id, "2").setConfig((GraphDatabaseSetting)HaSettings.server, "localhost:6362").setConfig((GraphDatabaseSetting)HaSettings.pull_interval, "0").newGraphDatabase();
    }

    @After
    public void shutdown() {
        this.slave1.shutdown();
        this.master.shutdown();
    }

    @Test
    @EnabledBreakpoints(value={"applyCommittedTransaction"})
    public void doTheDamnTest() throws Exception {
        Assert.assertEquals((Object)"123", (Object)this.slave1.getNodeById(1L).getProperty("uuid"));
        Transaction tx = this.master.beginTx();
        Node toRemove = (Node)this.master.index().forNodes("auto").get("uuid", (Object)"123").next();
        long nodeId = toRemove.getId();
        this.master.index().forNodes("auto").remove((PropertyContainer)toRemove);
        toRemove.delete();
        tx.success();
        tx.finish();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                TestPartialPullUpdates.this.slave1.pullUpdates();
            }
        });
        t.start();
        t.join();
        if (this.slave1.index().forNodes("auto").get("uuid", (Object)"123").hasNext()) {
            System.out.println("it was in the index");
            Assert.assertEquals((Object)"123", (Object)this.slave1.getNodeById(nodeId).getProperty("uuid"));
        } else {
            System.out.println("it was not in the index");
            try {
                this.slave1.getNodeById(nodeId);
                Assert.fail((String)"Node should not be there");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
        }
    }

    @BreakpointHandler(value={"applyCommittedTransaction"})
    public static void onApplyCommittedHandler(BreakPoint self, DebugInterface di) {
        if (self.invocationCount() < 2) {
            di.thread().resume();
        } else {
            di.thread().stop();
        }
    }
}

