/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.test.ManagedResource;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

@Ignore(value="We want to tie the thing owning the instanceId to the HA db, but the extensions need access to the internal db through the KernelData object while starting the internal db, making for an impossible circular reference")
public class HaKernelDataTest {
    @Rule
    public final ManagedResource<HighlyAvailableGraphDatabase> ha = new ManagedResource<HighlyAvailableGraphDatabase>(){

        @Override
        protected HighlyAvailableGraphDatabase createResource(TargetDirectory.TestDirectory dir) throws Exception {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put(HaSettings.server_id.name(), "1");
            config.put(HaSettings.coordinators.name(), this.zkConnection());
            return new HighlyAvailableGraphDatabase(dir.directory().getAbsolutePath(), config);
        }

        private String zkConnection() throws Exception {
            return LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection().getConnectionString();
        }

        @Override
        protected void disposeResource(HighlyAvailableGraphDatabase resource) {
            resource.shutdown();
        }
    };

    @Test
    public void shouldReturnHaGraphDbFromKernelData() throws Exception {
        HighlyAvailableGraphDatabase haGraphDb = this.ha.getResource();
        KernelData kernelData = haGraphDb.getKernelData();
        Assert.assertSame((Object)kernelData.graphDatabase(), (Object)haGraphDb);
    }

    @Test
    public void shouldNotInstantiateNewKernelDataOnInternalRestart() throws Exception {
        HighlyAvailableGraphDatabase haGraphDb = this.ha.getResource();
        KernelData kernelData = haGraphDb.getKernelData();
        haGraphDb.internalShutdown(false);
        haGraphDb.reevaluateMyself();
        Assert.assertSame((Object)kernelData, (Object)haGraphDb.getKernelData());
    }
}

