/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.kernel.ha.MasterClient153;
import org.neo4j.kernel.ha.MasterClient17;
import org.neo4j.kernel.ha.MasterClient18;
import org.neo4j.kernel.ha.MasterClientResolver;
import org.neo4j.kernel.impl.util.StringLogger;

public class MasterClientResolverTest {
    @Test
    public void testDefault() {
        MasterClientResolver resolver = new MasterClientResolver(StringLogger.SYSTEM, 0, 0, 0);
        Assert.assertEquals((String)"default was not the latest one", MasterClientResolver.F18.class, resolver.getDefault().getClass());
    }

    @Test
    public void testAskedVersionWorks() {
        MasterClientResolver resolver = new MasterClientResolver(StringLogger.SYSTEM, 0, 0, 0);
        Assert.assertEquals((String)"wrong version returned for version 2", MasterClientResolver.F153.class, resolver.getFor(2, 2).getClass());
        Assert.assertEquals((String)"wrong version returned for version 3", MasterClientResolver.F17.class, resolver.getFor(3, 2).getClass());
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClientResolver.F18.class, resolver.getFor(4, 2).getClass());
    }

    @Test
    public void testUnknownVersionReturnsNull() {
        MasterClientResolver resolver = new MasterClientResolver(StringLogger.SYSTEM, 0, 0, 0);
        Assert.assertNull((String)"Should return nothing on unknwon version", (Object)resolver.getFor(-1, -1));
    }

    @Test(expected=NullPointerException.class)
    public void testNonBootstrappedDoesNotReturn() {
        MasterClientResolver resolver = new MasterClientResolver(StringLogger.SYSTEM, 0, 0, 0);
        resolver.instantiate("", 0, null);
    }

    @Test
    public void testUnknownVersionLeavesPreviousInPlace() {
        MasterClientResolver resolver = new MasterClientResolver(StringLogger.SYSTEM, 0, 0, 0);
        resolver.getDefault();
        MasterClient currentClient = resolver.instantiate("", 0, null);
        Class<?> previousClass = currentClient.getClass();
        Assert.assertNull((Object)resolver.getFor(-1, -1));
        Assert.assertEquals((String)"class was not the same after getting unknown protocol", previousClass, currentClient.getClass());
        currentClient.shutdown();
    }

    @Test
    public void testAskedVersionSticks() {
        MasterClientResolver resolver = new MasterClientResolver(StringLogger.SYSTEM, 0, 0, 0);
        resolver.getFor(2, 2);
        MasterClient currentClient = resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 2", MasterClient153.class, currentClient.getClass());
        currentClient.shutdown();
        resolver.getFor(3, 2);
        currentClient = resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 3", MasterClient17.class, currentClient.getClass());
        currentClient.shutdown();
        resolver.getFor(4, 2);
        currentClient = resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClient18.class, currentClient.getClass());
        currentClient.shutdown();
    }

    @Test
    public void testDowngradesArePossibleIfNotLocked() {
        MasterClientResolver resolver = new MasterClientResolver(StringLogger.SYSTEM, 0, 0, 0);
        resolver.getFor(4, 2);
        MasterClient currentClient = resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClient18.class, currentClient.getClass());
        currentClient.shutdown();
        resolver.getFor(3, 2);
        currentClient = resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClient17.class, currentClient.getClass());
        currentClient.shutdown();
        resolver.getFor(2, 2);
        currentClient = resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClient153.class, currentClient.getClass());
        currentClient.shutdown();
    }

    @Test
    public void testDowngradesArePossibleUntilLocked() {
        MasterClientResolver resolver = new MasterClientResolver(StringLogger.SYSTEM, 0, 0, 0);
        resolver.getFor(4, 2);
        MasterClient currentClient = resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClient18.class, currentClient.getClass());
        currentClient.shutdown();
        resolver.getFor(3, 2);
        currentClient = resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClient17.class, currentClient.getClass());
        currentClient.shutdown();
        resolver.enableDowngradeBarrier();
        resolver.getFor(2, 2);
        currentClient = resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"wrong version returned for version 4", MasterClient17.class, currentClient.getClass());
        currentClient.shutdown();
    }

    @Test
    public void downgradeDoesNotHappenWhenLocked() {
        MasterClientResolver resolver = new MasterClientResolver(StringLogger.SYSTEM, 0, 0, 0);
        resolver.getFor(3, 2);
        resolver.enableDowngradeBarrier();
        resolver.getFor(2, 2);
        MasterClient currentClient = resolver.instantiate("", 0, null);
        Assert.assertEquals((String)"locking should not allow downgrade", MasterClient17.class, currentClient.getClass());
        currentClient.shutdown();
    }

    @Test
    public void lockingShouldNotPreventBootstrapping() {
        MasterClientResolver resolver = new MasterClientResolver(StringLogger.SYSTEM, 0, 0, 0);
        resolver.enableDowngradeBarrier();
        resolver.getFor(3, 2);
        MasterClient currentClient = resolver.instantiate("", 0, null);
        Assert.assertEquals(MasterClient17.class, currentClient.getClass());
        currentClient.shutdown();
        currentClient = resolver.instantiate("", 0, null);
        resolver.getFor(2, 2);
        Assert.assertEquals((String)"locking should not allow downgrade", MasterClient17.class, currentClient.getClass());
        currentClient.shutdown();
    }
}

