/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.kernel.EnterpriseGraphDatabaseFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestTxPushStrategyConfig {
    private LocalhostZooKeeperCluster zoo;
    private GraphDatabaseAPI master;
    private List<GraphDatabaseAPI> slaves = new ArrayList<GraphDatabaseAPI>();
    private TargetDirectory dir;

    @Before
    public void before() throws Exception {
        this.dir = TargetDirectory.forTest(this.getClass());
        this.zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
    }

    @After
    public void after() throws Exception {
        for (GraphDatabaseAPI slave : this.slaves) {
            slave.shutdown();
        }
        this.master.shutdown();
    }

    GraphDatabaseService startMaster(int pushFactor, String pushStrategy) {
        this.master = (GraphDatabaseAPI)new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.dir.directory("1", true).getAbsolutePath()).setConfig((GraphDatabaseSetting)HaSettings.coordinators, this.zoo.getConnectionString()).setConfig((GraphDatabaseSetting)HaSettings.server_id, "1").setConfig((GraphDatabaseSetting)HaSettings.server, "localhost:6361").setConfig((GraphDatabaseSetting)HaSettings.tx_push_factor, "" + pushFactor).setConfig((GraphDatabaseSetting)HaSettings.tx_push_strategy, pushStrategy).newGraphDatabase();
        return this.master;
    }

    void addSlaves(int count) {
        for (int i = 1; i <= count; ++i) {
            this.slaves.add((GraphDatabaseAPI)new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.dir.directory("" + (1 + i), true).getAbsolutePath()).setConfig((GraphDatabaseSetting)HaSettings.coordinators, this.zoo.getConnectionString()).setConfig((GraphDatabaseSetting)HaSettings.server_id, "" + (i + 1)).setConfig((GraphDatabaseSetting)HaSettings.server, "localhost:" + (6361 + i)).newGraphDatabase());
        }
    }

    @Test
    public void twoFixed() throws Exception {
        this.startMaster(2, "fixed");
        this.addSlaves(3);
        for (int i = 0; i < 5; ++i) {
            this.createTransactionOnMaster();
            this.assertLastTxId(2 + i, 4);
            this.assertLastTxId(2 + i, 3);
            this.assertLastTxId(1L, 2);
        }
    }

    @Test
    public void twoRoundRobin() throws Exception {
        this.startMaster(2, "round_robin");
        this.addSlaves(4);
        this.createTransactionOnMaster();
        this.assertLastTxId(2L, 2);
        this.assertLastTxId(2L, 3);
        this.assertLastTxId(1L, 4);
        this.assertLastTxId(1L, 5);
        this.createTransactionOnMaster();
        this.assertLastTxId(2L, 2);
        this.assertLastTxId(3L, 3);
        this.assertLastTxId(3L, 4);
        this.assertLastTxId(1L, 5);
        this.createTransactionOnMaster();
        this.assertLastTxId(2L, 2);
        this.assertLastTxId(3L, 3);
        this.assertLastTxId(4L, 4);
        this.assertLastTxId(4L, 5);
        this.createTransactionOnMaster();
        this.assertLastTxId(5L, 2);
        this.assertLastTxId(3L, 3);
        this.assertLastTxId(4L, 4);
        this.assertLastTxId(5L, 5);
    }

    @Test
    public void twoFixedFromSlaveCommit() throws Exception {
        this.startMaster(2, "fixed");
        this.addSlaves(3);
        this.createTransactionOnSlave(2);
        this.assertLastTxId(2L, 4);
        this.assertLastTxId(1L, 3);
        this.assertLastTxId(2L, 2);
        this.assertLastTxId(2L, 1);
        this.createTransactionOnSlave(3);
        this.assertLastTxId(3L, 4);
        this.assertLastTxId(3L, 3);
        this.assertLastTxId(2L, 2);
        this.assertLastTxId(3L, 1);
        this.createTransactionOnSlave(4);
        this.assertLastTxId(4L, 4);
        this.assertLastTxId(4L, 3);
        this.assertLastTxId(2L, 2);
        this.assertLastTxId(4L, 1);
    }

    private void assertLastTxId(long tx, int serverId) {
        GraphDatabaseAPI db = serverId == 1 ? this.master : this.getSlave(serverId);
        Assert.assertEquals((long)tx, (long)db.getXaDataSourceManager().getNeoStoreDataSource().getLastCommittedTxId());
    }

    private GraphDatabaseAPI getSlave(int serverId) {
        return this.slaves.get(serverId - 2);
    }

    private void createTransactionOnMaster() {
        this.createTransaction(this.master);
    }

    private void createTransactionOnSlave(int serverId) {
        System.out.println("Creating tx on " + serverId);
        this.createTransaction(this.getSlave(serverId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTransaction(GraphDatabaseAPI db) {
        Transaction tx = db.beginTx();
        try {
            db.createNode();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }
}

