/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.neo4j.graphdb.factory.Default;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.Migrator;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.ha.EnterpriseConfigurationMigrator;

public class HaSettings {
    @Migrator
    public static final ConfigurationMigrator migrator = new EnterpriseConfigurationMigrator();
    public static final GraphDatabaseSetting.StringSetting coordinators = new GraphDatabaseSetting.StringSetting("ha.coordinators", ".+", "Must be valid list of host names");
    @Default(value="20")
    public static final GraphDatabaseSetting.IntegerSetting read_timeout = new GraphDatabaseSetting.IntegerSetting("ha.read_timeout", "Must be valid timeout in seconds", Integer.valueOf(5), null);
    public static final GraphDatabaseSetting.IntegerSetting lock_read_timeout = new GraphDatabaseSetting.IntegerSetting("ha.lock_read_timeout", "Must be valid timeout in seconds", Integer.valueOf(1), null);
    @Default(value="20")
    public static final GraphDatabaseSetting.IntegerSetting max_concurrent_channels_per_slave = new GraphDatabaseSetting.IntegerSetting("ha.max_concurrent_channels_per_slave", "Must be valid timeout in seconds", Integer.valueOf(1), null);
    public static final GraphDatabaseSetting.IntegerSetting server_id = new GraphDatabaseSetting.IntegerSetting("ha.server_id", "Must be a valid server id");
    public static final GraphDatabaseSetting.StringSetting server = new GraphDatabaseSetting.StringSetting("ha.server", ".+", "Must be a valid IP and port to bind to as master");
    @Default(value="async")
    public static final SlaveUpdateModeSetting slave_coordinator_update_mode = new SlaveUpdateModeSetting();
    @Default(value="neo4j.ha")
    public static final GraphDatabaseSetting.StringSetting cluster_name = new GraphDatabaseSetting.StringSetting("ha.cluster_name", ".+", "Must be a valid cluster name");
    @Default(value="true")
    public static final GraphDatabaseSetting.BooleanSetting allow_init_cluster = new GraphDatabaseSetting.BooleanSetting("ha.allow_init_cluster");
    @Default(value="5000")
    public static final GraphDatabaseSetting.IntegerSetting zk_session_timeout = new GraphDatabaseSetting.IntegerSetting("ha.zk_session_timeout", "Must be a valid timeout in milliseconds", Integer.valueOf(1), null);
    @Default(value="500")
    public static final GraphDatabaseSetting.IntegerSetting coordinator_fetch_info_timeout = new GraphDatabaseSetting.IntegerSetting("ha.coordinator_fetch_info_timeout", "Must be a valid timeout in seconds", Integer.valueOf(1), null);
    @Default(value="keep_all")
    public static final BranchedDataPolicySetting branched_data_policy = new BranchedDataPolicySetting();
    @Default(value="0")
    public static final GraphDatabaseSetting.StringSetting pull_interval = new GraphDatabaseSetting.StringSetting("ha.pull_interval", ".+", "Must be valid interval setting");
    @Description(value="The amount of slaves the master will ask to replicate a committed transaction. The master will not throw an exception on commit if the replication failed.")
    @Default(value="1")
    public static final GraphDatabaseSetting.IntegerSetting tx_push_factor = new GraphDatabaseSetting.IntegerSetting("ha.tx_push_factor", "Must be a valid replication factor", Integer.valueOf(0), null);
    @Description(value="Push strategy of a transaction to a slave during commit.  Round robin (\"round_robin\")   or fixed (\"fixed\") selecting the slave with highest machine id first")
    @Default(value="fixed")
    public static final GraphDatabaseSetting.OptionsSetting tx_push_strategy = new TxPushStrategySetting();

    public static final class BranchedDataPolicySetting
    extends GraphDatabaseSetting.OptionsSetting {
        @Description(value="Update mode 'keep_all'")
        public static final String keep_all = "keep_all";
        @Description(value="Update mode 'keep_last'")
        public static final String keep_last = "keep_last";
        @Description(value="Update mode 'keep_none'")
        public static final String keep_none = "keep_none";
        @Description(value="Update mode 'shutdown'")
        public static final String shutdown = "shutdown";

        public BranchedDataPolicySetting() {
            super("ha.branched_data_policy", new String[]{keep_all, keep_last, keep_none, shutdown});
        }
    }

    public static final class SlaveUpdateModeSetting
    extends GraphDatabaseSetting.OptionsSetting {
        @Description(value="Update mode 'sync'")
        public static final String sync = "sync";
        @Description(value="Update mode 'async'")
        public static final String async = "async";
        @Description(value="Update mode 'none'")
        public static final String none = "none";

        public SlaveUpdateModeSetting() {
            super("ha.slave_coordinator_update_mode", new String[]{sync, async, none});
        }
    }

    public static class TxPushStrategySetting
    extends GraphDatabaseSetting.OptionsSetting {
        @Description(value="Round robin")
        public static final String roundRobin = "round_robin";
        @Description(value="Fixed")
        public static final String fixed = "fixed";

        public TxPushStrategySetting() {
            super("ha.tx_push_strategy", new String[]{roundRobin, fixed});
        }
    }
}

