/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.Client;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.TargetCaller;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.Slave;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;

public class SlaveClient
extends Client<Slave>
implements Slave {
    private final int machineId;

    public SlaveClient(int machineId, String hostNameOrIp, int port, StringLogger logger, StoreId storeId, int maxConcurrentChannels) {
        super(hostNameOrIp, port, logger, storeId, 0x1000000, (byte)1, Integer.parseInt(ConfigurationDefaults.getDefault((GraphDatabaseSetting)HaSettings.read_timeout, HaSettings.class)), maxConcurrentChannels, maxConcurrentChannels);
        this.machineId = machineId;
    }

    @Override
    public Response<Void> pullUpdates(final String resource, final long upToAndIncludingTxId) {
        return this.sendRequest(SlaveRequestType.PULL_UPDATES, RequestContext.EMPTY, new Serializer(){

            public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)resource);
                buffer.writeLong(upToAndIncludingTxId);
            }
        }, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public int getServerId() {
        return this.machineId;
    }

    static enum SlaveRequestType implements RequestType<Slave>
    {
        PULL_UPDATES((TargetCaller)new TargetCaller<Slave, Void>(){

            public Response<Void> call(Slave master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.pullUpdates(Protocol.readString((ChannelBuffer)input), input.readLong());
            }
        }, Protocol.VOID_SERIALIZER);

        private final TargetCaller caller;
        private final ObjectSerializer serializer;

        private SlaveRequestType(TargetCaller caller, ObjectSerializer serializer) {
            this.caller = caller;
            this.serializer = serializer;
        }

        public TargetCaller getTargetCaller() {
            return this.caller;
        }

        public ObjectSerializer getObjectSerializer() {
            return this.serializer;
        }

        public byte id() {
            return (byte)this.ordinal();
        }
    }
}

