/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.ha.AbstractHAGraphDatabase;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.SlaveDatabaseOperations;
import org.neo4j.kernel.ha.SlaveIdGenerator;
import org.neo4j.kernel.ha.SlaveLockManager;
import org.neo4j.kernel.ha.SlaveRelationshipTypeCreator;
import org.neo4j.kernel.ha.SlaveTxHook;
import org.neo4j.kernel.ha.SlaveTxIdGenerator;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.logging.Logging;

public class SlaveGraphDatabase
extends AbstractHAGraphDatabase {
    private final SlaveDatabaseOperations databaseOperations;
    private LastCommittedTxIdSetter lastCommittedTxIdSetter;
    private SlaveIdGenerator.SlaveIdGeneratorFactory slaveIdGeneratorFactory;
    private FileSystemAbstraction fileSystemAbstraction;

    public SlaveGraphDatabase(String storeDir, Map<String, String> params, StoreId storeId, HighlyAvailableGraphDatabase highlyAvailableGraphDatabase, Broker broker, Logging logging, SlaveDatabaseOperations databaseOperations, LastCommittedTxIdSetter lastCommittedTxIdSetter, NodeProxy.NodeLookup nodeLookup, RelationshipProxy.RelationshipLookups relationshipLookups, FileSystemAbstraction fileSystemAbstraction, Iterable<IndexProvider> indexProviders, Iterable<KernelExtension> kernelExtensions, Iterable<CacheProvider> cacheProviders, Caches caches) {
        super(storeDir, params, storeId, highlyAvailableGraphDatabase, broker, logging, nodeLookup, relationshipLookups, indexProviders, kernelExtensions, cacheProviders, caches);
        this.fileSystemAbstraction = fileSystemAbstraction;
        assert (broker != null && logging != null && databaseOperations != null && lastCommittedTxIdSetter != null && nodeLookup != null && relationshipLookups != null);
        this.databaseOperations = databaseOperations;
        this.lastCommittedTxIdSetter = lastCommittedTxIdSetter;
        this.run();
    }

    protected TxHook createTxHook() {
        return new SlaveTxHook(this.broker, this.databaseOperations, (GraphDatabaseAPI)this);
    }

    protected FileSystemAbstraction createFileSystemAbstraction() {
        return this.fileSystemAbstraction;
    }

    protected LastCommittedTxIdSetter createLastCommittedTxIdSetter() {
        return this.lastCommittedTxIdSetter;
    }

    protected TxIdGenerator createTxIdGenerator() {
        assert (this.txManager != null);
        return new SlaveTxIdGenerator(this.broker, this.databaseOperations, (TransactionManager)this.txManager);
    }

    protected IdGeneratorFactory createIdGeneratorFactory() {
        this.slaveIdGeneratorFactory = new SlaveIdGenerator.SlaveIdGeneratorFactory(this.broker, this.databaseOperations);
        return this.slaveIdGeneratorFactory;
    }

    protected LockManager createLockManager() {
        assert (this.txManager != null && this.txHook != null);
        return new SlaveLockManager(this.ragManager, (TxManager)this.txManager, this.txHook, this.broker, this.databaseOperations);
    }

    public void forgetIdAllocationsFromMaster() {
        this.slaveIdGeneratorFactory.forgetIdAllocationsFromMaster();
    }

    protected RelationshipTypeCreator createRelationshipTypeCreator() {
        return new SlaveRelationshipTypeCreator(this.broker, this.databaseOperations);
    }
}

