/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.ha.ClusterClient;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterClientFactory;
import org.neo4j.kernel.ha.MasterClientResolver;
import org.neo4j.kernel.ha.zookeeper.AbstractZooKeeperManager;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperMachine;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;

public class ZooKeeperClusterClient
extends AbstractZooKeeperManager
implements ClusterClient {
    protected static final int SESSION_TIME_OUT = 5000;
    public static final int CLUSTER_CLIENT_MACHINE_ID = -1;
    private final ZooKeeper zooKeeper;
    private String rootPath;
    private Watcher.Event.KeeperState state = Watcher.Event.KeeperState.Disconnected;
    private final String clusterName;

    public ZooKeeperClusterClient(String zooKeeperServers) {
        this(zooKeeperServers, ConfigurationDefaults.getDefault((GraphDatabaseSetting)HaSettings.cluster_name, HaSettings.class));
    }

    public ZooKeeperClusterClient(String zooKeeperServers, String clusterName) {
        this(zooKeeperServers, StringLogger.SYSTEM, clusterName, Integer.parseInt(ConfigurationDefaults.getDefault((GraphDatabaseSetting)HaSettings.zk_session_timeout, HaSettings.class)), new MasterClientResolver.F18(StringLogger.SYSTEM, 20, 20, 20));
    }

    public ZooKeeperClusterClient(String zooKeeperServers, StringLogger msgLog, String clusterName, int sessionTimeout, MasterClientFactory factory) {
        super(zooKeeperServers, msgLog, sessionTimeout, factory);
        this.clusterName = clusterName;
        try {
            this.zooKeeper = new ZooKeeper(zooKeeperServers, 5000, (Watcher)new WatcherImpl());
        }
        catch (IOException e) {
            throw new ZooKeeperException("Unable to create zoo keeper client", e);
        }
    }

    @Override
    void waitForSyncConnected(AbstractZooKeeperManager.WaitMode waitMode) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)this.getSessionTimeout() && this.state != Watcher.Event.KeeperState.SyncConnected) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    @Override
    protected int getMyMachineId() {
        return -1;
    }

    @Override
    public int getBackupPort(int machineId) {
        int port = this.readHaServer(machineId, true).getBackupPort();
        return port != 0 ? port : 6362;
    }

    @Override
    public Machine getMaster() {
        if (this.readRootPath() == null) {
            return null;
        }
        return this.getMasterBasedOn(this.getAllMachines(true).values());
    }

    @Override
    public Pair<Master, Machine> getMasterClient() {
        Machine masterMachine = this.getMaster();
        if (masterMachine == null) {
            return null;
        }
        Master masterClient = this.getMasterClientToMachine(masterMachine);
        return Pair.of((Object)masterClient, (Object)masterMachine);
    }

    @Override
    public String getRoot() {
        if (this.rootPath == null) {
            this.rootPath = this.readRootPath();
        }
        return this.rootPath;
    }

    private String readRootPath() {
        this.waitForSyncConnected();
        StoreId storeId = this.getClusterStoreId(this.zooKeeper, this.clusterName);
        if (storeId == null) {
            throw new RuntimeException("Cluster '" + this.clusterName + "' not found");
        }
        return this.asRootPath(storeId);
    }

    @Override
    public Machine[] getConnectedSlaves() {
        Map<Integer, ZooKeeperMachine> machines = this.getAllMachines(true);
        ZooKeeperMachine master = this.getMasterBasedOn(machines.values());
        ArrayList<ZooKeeperMachine> result = new ArrayList<ZooKeeperMachine>(machines.values());
        result.remove(master);
        return result.toArray(new Machine[result.size()]);
    }

    @Override
    public ZooKeeper getZooKeeper(boolean sync) {
        if (sync) {
            this.zooKeeper.sync(this.getRoot(), null, null);
        }
        return this.zooKeeper;
    }

    private class WatcherImpl
    implements Watcher {
        private WatcherImpl() {
        }

        public void process(WatchedEvent event) {
            String path = event.getPath();
            if (path == null) {
                ZooKeeperClusterClient.this.state = event.getState();
            }
        }
    }
}

