/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.EnterpriseGraphDatabaseFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestLogging {
    String masterDir;
    String slaveDir;
    GraphDatabaseAPI master;
    GraphDatabaseAPI slave;

    @Before
    public void before() throws Exception {
        LocalhostZooKeeperCluster zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
        File dir = TargetDirectory.forTest(this.getClass()).directory("dbs", true);
        this.masterDir = new File(dir, "0").getAbsolutePath();
        this.master = (GraphDatabaseAPI)new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.masterDir).setConfig((Setting)HaSettings.server, "localhost:6361").setConfig((Setting)HaSettings.server_id, "0").setConfig((Setting)HaSettings.coordinators, zoo.getConnectionString()).newGraphDatabase();
        this.slaveDir = new File(dir, "1").getAbsolutePath();
        this.slave = (GraphDatabaseAPI)new EnterpriseGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.slaveDir).setConfig((Setting)HaSettings.server, "localhost:6362").setConfig((Setting)HaSettings.server_id, "1").setConfig((Setting)HaSettings.coordinators, zoo.getConnectionString()).newGraphDatabase();
    }

    @After
    public void after() throws Exception {
        if (this.slave != null) {
            this.slave.shutdown();
        }
        if (this.master != null) {
            this.master.shutdown();
        }
    }

    @Test
    public void makeSureMessagesAreLoggedAfterInitialStoreCopy() throws Exception {
        this.slave.shutdown();
        this.slave = null;
        this.master.shutdown();
        this.master = null;
        this.assertMessagesLogContains(this.slaveDir, "STARTUP diagnostics");
    }

    @Test
    public void makeSureMessagesAreLoggedAfterBrokerReconnect() throws Exception {
        ((HighlyAvailableGraphDatabase)this.slave).getBroker().restart();
        this.slave.getXaDataSourceManager().getNeoStoreDataSource().rotateLogicalLog();
        this.assertMessagesLogContains(this.slaveDir, "Rotating [");
    }

    private void assertMessagesLogContains(String slaveDir, String expectingToFind) {
        boolean found = false;
        for (String line : IteratorUtil.asIterable((File)new File(slaveDir, "messages.log"))) {
            if (!line.contains(expectingToFind)) continue;
            found = true;
        }
        Assert.assertTrue((String)("Expected to find at least one log message including '" + expectingToFind + "' but didn't"), (boolean)found);
    }
}

