/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.AbstractBroker;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterImpl;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.kernel.ha.Slave;
import org.neo4j.kernel.ha.SlaveClient;
import org.neo4j.kernel.ha.SlaveDatabaseOperations;
import org.neo4j.kernel.ha.zookeeper.Machine;

public class FakeMasterBroker
extends AbstractBroker {
    private final Collection<Slave> slaves = new ArrayList<Slave>();

    public FakeMasterBroker(Config conf) {
        super(conf);
    }

    public Machine getMasterMachine() {
        return new Machine(this.getMyMachineId(), 0, 1L, -1, null, 0);
    }

    public Pair<Master, Machine> getMaster() {
        return Pair.of(null, (Object)new Machine(this.getMyMachineId(), 0, 1L, -1, null, 0));
    }

    public Pair<Master, Machine> getMasterReally(boolean allowChange) {
        return Pair.of(null, (Object)new Machine(this.getMyMachineId(), 0, 1L, -1, null, 0));
    }

    public boolean iAmMaster() {
        return this.getMyMachineId() == 0;
    }

    public Object instantiateMasterServer(GraphDatabaseAPI graphDb) {
        int timeOut = this.config.isSet((GraphDatabaseSetting)HaSettings.lock_read_timeout) ? this.config.getInteger(HaSettings.lock_read_timeout) : this.config.getInteger(HaSettings.read_timeout);
        return new MasterServer((Master)new MasterImpl(graphDb, timeOut), 8901, graphDb.getMessageLog(), this.config.getInteger(HaSettings.max_concurrent_channels_per_slave), timeOut, TxChecksumVerifier.ALWAYS_MATCH, 0x1000000);
    }

    public Object instantiateSlaveServer(GraphDatabaseAPI graphDb, SlaveDatabaseOperations ops) {
        throw new UnsupportedOperationException();
    }

    public Slave[] getSlaves() {
        return this.slaves.toArray(new Slave[this.slaves.size()]);
    }

    public void addSlave(Slave slave) {
        this.slaves.add(slave);
    }

    public void shutdown() {
        for (Slave slave : this.slaves) {
            ((SlaveClient)slave).shutdown();
        }
    }
}

