/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.com.ComException;
import org.neo4j.com.IllegalProtocolVersionException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.ToFileStoreWriter;
import org.neo4j.com.TxExtractor;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.InformativeStackTrace;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.SlaveUpdateMode;
import org.neo4j.kernel.TransactionBuilder;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.ClusterClient;
import org.neo4j.kernel.ha.ClusterEventReceiver;
import org.neo4j.kernel.ha.DatabaseNotRunningException;
import org.neo4j.kernel.ha.HaCaches;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterClientResolver;
import org.neo4j.kernel.ha.MasterGraphDatabase;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.kernel.ha.SlaveDatabaseOperations;
import org.neo4j.kernel.ha.SlaveGraphDatabase;
import org.neo4j.kernel.ha.SlaveServer;
import org.neo4j.kernel.ha.shell.ZooClientFactory;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.NoMasterException;
import org.neo4j.kernel.ha.zookeeper.ZooClient;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperBroker;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperClusterClient;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.persistence.PersistenceSource;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.ClassicLoggingService;
import org.neo4j.kernel.logging.LogbackService;
import org.neo4j.kernel.logging.Logging;

public class HighlyAvailableGraphDatabase
extends AbstractGraphDatabase
implements GraphDatabaseService,
GraphDatabaseAPI {
    private static final int NEW_MASTER_STARTUP_RETRIES = 3;
    public static final String COPY_FROM_MASTER_TEMP = "temp-copy";
    private static final int STORE_COPY_RETRIES = 3;
    private final int localGraphWait;
    protected volatile StoreId storeId;
    private LifeSupport life = new LifeSupport();
    protected Logging logging;
    protected Config configuration;
    private String storeDir;
    private Iterable<IndexProvider> indexProviders;
    private Iterable<KernelExtension> kernelExtensions;
    private Iterable<CacheProvider> cacheProviders;
    private final StringLogger messageLog;
    private volatile InternalAbstractGraphDatabase internalGraphDatabase;
    private NodeProxy.NodeLookup nodeLookup;
    private RelationshipProxy.RelationshipLookups relationshipLookups;
    private final LocalDatabaseOperations slaveOperations;
    private volatile Broker broker;
    private ClusterClient clusterClient;
    private int machineId;
    private volatile MasterServer masterServer;
    private volatile SlaveServer slaveServer;
    private ScheduledExecutorService updatePuller;
    private volatile long updateTime = 0L;
    private volatile Throwable causeOfShutdown;
    private long startupTime;
    private BranchedDataPolicy branchedDataPolicy;
    private final SlaveUpdateMode slaveUpdateMode;
    private final Caches caches;
    private final MasterClientResolver masterClientResolver;
    private volatile boolean pullUpdates;
    private final List<KernelEventHandler> kernelEventHandlers = new CopyOnWriteArrayList<KernelEventHandler>();
    private final Collection<TransactionEventHandler<?>> transactionEventHandlers = new CopyOnWriteArraySet();
    protected final FileSystemAbstraction fileSystemAbstraction;
    private DependencyResolver haDependencyResolver = new DependencyResolver(){

        public <T> T resolveDependency(Class<T> type) throws IllegalArgumentException {
            if (type.equals(MasterGraphDatabase.class) && HighlyAvailableGraphDatabase.this.internalGraphDatabase instanceof MasterGraphDatabase) {
                return (T)HighlyAvailableGraphDatabase.this.internalGraphDatabase;
            }
            if (type.equals(SlaveGraphDatabase.class) && HighlyAvailableGraphDatabase.this.internalGraphDatabase instanceof SlaveGraphDatabase) {
                return (T)HighlyAvailableGraphDatabase.this.internalGraphDatabase;
            }
            throw new IllegalArgumentException("Could not resolve dependency of type:" + type.getName());
        }
    };

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> config) {
        this(storeDir, config, Service.load(IndexProvider.class), Service.load(KernelExtension.class), Service.load(CacheProvider.class));
    }

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> config, Iterable<IndexProvider> indexProviders, Iterable<KernelExtension> kernelExtensions, Iterable<CacheProvider> cacheProviders) {
        this.storeDir = storeDir;
        this.indexProviders = indexProviders;
        this.kernelExtensions = kernelExtensions;
        this.cacheProviders = cacheProviders;
        config.put(GraphDatabaseSettings.keep_logical_logs.name(), "true");
        config.put(InternalAbstractGraphDatabase.Configuration.store_dir.name(), storeDir);
        if (!config.containsKey(GraphDatabaseSettings.cache_type.name())) {
            config.put(GraphDatabaseSettings.cache_type.name(), "gcr");
        }
        this.configuration = new Config(config, new Class[]{GraphDatabaseSettings.class, HaSettings.class, OnlineBackupSettings.class});
        this.logging = this.createLogging();
        this.messageLog = this.logging.getLogger("neo4j");
        this.configuration.setLogger(this.messageLog);
        this.fileSystemAbstraction = new DefaultFileSystemAbstraction();
        this.caches = new HaCaches(this.messageLog);
        this.slaveOperations = new LocalDatabaseOperations();
        this.nodeLookup = new HANodeLookup();
        this.relationshipLookups = new HARelationshipLookups();
        this.startupTime = System.currentTimeMillis();
        this.kernelEventHandlers.add(new TxManagerCheckKernelEventHandler());
        this.slaveUpdateMode = (SlaveUpdateMode)this.configuration.getEnum(SlaveUpdateMode.class, (GraphDatabaseSetting.OptionsSetting)HaSettings.slave_coordinator_update_mode);
        this.machineId = (Integer)this.configuration.get((GraphDatabaseSetting)HaSettings.server_id);
        this.branchedDataPolicy = (BranchedDataPolicy)this.configuration.getEnum(BranchedDataPolicy.class, (GraphDatabaseSetting.OptionsSetting)HaSettings.branched_data_policy);
        this.localGraphWait = (Integer)this.configuration.get((GraphDatabaseSetting)HaSettings.read_timeout);
        this.masterClientResolver = new MasterClientResolver(this.messageLog, (Integer)this.configuration.get((GraphDatabaseSetting)HaSettings.read_timeout), this.configuration.isSet((GraphDatabaseSetting)HaSettings.lock_read_timeout) ? (Integer)this.configuration.get((GraphDatabaseSetting)HaSettings.lock_read_timeout) : (Integer)this.configuration.get((GraphDatabaseSetting)HaSettings.read_timeout), (Integer)this.configuration.get((GraphDatabaseSetting)HaSettings.max_concurrent_channels_per_slave), (Integer)this.configuration.get(HaSettings.com_chunk_size));
        this.masterClientResolver.getDefault();
        this.broker = this.createBroker();
        this.pullUpdates = false;
        this.clusterClient = this.createClusterClient();
        this.migrateBranchedDataDirectoriesToRootDirectory();
        this.start();
    }

    private void migrateBranchedDataDirectoriesToRootDirectory() {
        File branchedDir = BranchedDataPolicy.getBranchedDataRootDirectory(this.storeDir);
        branchedDir.mkdirs();
        for (File oldBranchedDir : new File(this.storeDir).listFiles()) {
            if (!oldBranchedDir.isDirectory() || !oldBranchedDir.getName().startsWith("branched-")) continue;
            long timestamp = 0L;
            try {
                timestamp = Long.parseLong(oldBranchedDir.getName().substring(oldBranchedDir.getName().indexOf(45) + 1));
            }
            catch (NumberFormatException e) {
                continue;
            }
            File targetDir = BranchedDataPolicy.getBranchedDataDirectory(this.storeDir, timestamp);
            try {
                FileUtils.moveFile((File)oldBranchedDir, (File)targetDir);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't move branched directories to " + branchedDir, e);
            }
        }
    }

    private Logging createLogging() {
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("ch.qos.logback.classic.LoggerContext");
            return (Logging)this.life.add((Object)new LogbackService(this.configuration));
        }
        catch (ClassNotFoundException e) {
            return (Logging)this.life.add((Object)new ClassicLoggingService(this.configuration));
        }
    }

    public Node createNode() {
        return this.localGraph().createNode();
    }

    public Node getNodeById(long id) {
        return this.localGraph().getNodeById(id);
    }

    public Node getReferenceNode() {
        return this.localGraph().getReferenceNode();
    }

    public Iterable<Node> getAllNodes() {
        return this.localGraph().getAllNodes();
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.localGraph().getRelationshipTypes();
    }

    public Relationship getRelationshipById(long id) {
        return this.localGraph().getRelationshipById(id);
    }

    public IndexManager index() {
        return this.localGraph().index();
    }

    public Transaction beginTx() {
        return this.localGraph().beginTx();
    }

    public synchronized void shutdown() {
        this.shutdown(new IllegalStateException("shutdown called"), true);
    }

    public NodeManager getNodeManager() {
        return this.localGraph().getNodeManager();
    }

    public LockReleaser getLockReleaser() {
        return this.localGraph().getLockReleaser();
    }

    public LockManager getLockManager() {
        return this.localGraph().getLockManager();
    }

    public XaDataSourceManager getXaDataSourceManager() {
        return this.localGraph().getXaDataSourceManager();
    }

    public TransactionManager getTxManager() {
        return this.localGraph().getTxManager();
    }

    public DiagnosticsManager getDiagnosticsManager() {
        return this.localGraph().getDiagnosticsManager();
    }

    public StringLogger getMessageLog() {
        return this.messageLog;
    }

    public RelationshipTypeHolder getRelationshipTypeHolder() {
        return this.localGraph().getRelationshipTypeHolder();
    }

    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.localGraph().getIdGeneratorFactory();
    }

    public TxIdGenerator getTxIdGenerator() {
        return this.localGraph().getTxIdGenerator();
    }

    public KernelData getKernelData() {
        return this.localGraph().getKernelData();
    }

    public <T> T getSingleManagementBean(Class<T> type) {
        return (T)this.localGraph().getSingleManagementBean(type);
    }

    private void getFreshDatabaseFromMaster(boolean branched) {
        this.broker.shutdown();
        try {
            Pair<Master, Machine> master = this.createClusterClient().getMasterClient();
            this.internalShutdown(false);
            if (branched) {
                this.makeWayForNewDb();
            }
            Exception exception = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    BranchedDataPolicy.keep_none.handle(this);
                    this.copyStoreFromMaster(master);
                    this.moveCopiedStoreIntoWorkingDir();
                    return;
                }
                catch (Exception e) {
                    this.getMessageLog().logMessage("Problems copying store from master", (Throwable)e);
                    this.sleepWithoutInterruption(1000L, "");
                    exception = e;
                    master = this.clusterClient.getMasterClient();
                    continue;
                }
            }
            throw new RuntimeException("Gave up trying to copy store from master", exception);
        }
        finally {
            this.broker.start();
        }
    }

    private File getTempDir() {
        return new File(this.getStoreDir(), COPY_FROM_MASTER_TEMP);
    }

    private void moveCopiedStoreIntoWorkingDir() throws IOException {
        File storeDir = new File(this.getStoreDir());
        for (File candidate : this.getTempDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("messages.log");
            }
        })) {
            FileUtils.moveFileToDirectory((File)candidate, (File)storeDir);
        }
    }

    private File getClearedTempDir() throws IOException {
        File temp = this.getTempDir();
        if (!temp.mkdir()) {
            FileUtils.deleteRecursively((File)temp);
            temp.mkdir();
        }
        return temp;
    }

    void makeWayForNewDb() {
        this.messageLog.logMessage("Cleaning database " + this.storeDir + " (" + this.branchedDataPolicy.name() + ") to make way for new db from master");
        this.branchedDataPolicy.handle(this);
    }

    protected void start() {
        this.life.start();
        this.getMessageLog().logMessage("Starting up highly available graph database '" + this.getStoreDir() + "'");
        if (!new File(this.storeDir, "neostore").exists()) {
            Pair<Master, Machine> master;
            long endTime = System.currentTimeMillis() + 60000L;
            Exception exception = null;
            while (System.currentTimeMillis() < endTime && (master = this.broker.bootstrap()) != null && !((Machine)master.other()).equals(Machine.NO_MACHINE) && ((Machine)master.other()).getMachineId() != this.machineId) {
                try {
                    this.getFreshDatabaseFromMaster(false);
                    this.messageLog.logMessage("copied store from master");
                    exception = null;
                    break;
                }
                catch (Exception e) {
                    exception = e;
                    master = this.broker.getMasterReally(true);
                    this.messageLog.logMessage("Problems copying store from master", (Throwable)e);
                    this.sleepWithoutInterruption(300L, "Startup interrupted");
                }
            }
            if (exception != null) {
                throw new RuntimeException("Tried to join the cluster, but was unable to", exception);
            }
        }
        this.storeId = this.broker.getClusterStoreId(true);
        this.newMaster(new InformativeStackTrace("Starting up [" + this.machineId + "] for the first time"));
        this.localGraph();
        this.masterClientResolver.enableDowngradeBarrier();
    }

    private void checkAndRecoverCorruptLogs(InternalAbstractGraphDatabase localDb, boolean copiedStore) {
        this.getMessageLog().logMessage("Checking for log consistency");
        NeoStoreXaDataSource dataSource = localDb.getXaDataSourceManager().getNeoStoreDataSource();
        this.getMessageLog().logMessage("Checking dataSource " + dataSource.getName());
        boolean corrupted = false;
        long version = -1L;
        long myLastCommittedTx = dataSource.getLastCommittedTxId();
        if (myLastCommittedTx == 1L) {
            return;
        }
        try {
            int masterId = (Integer)dataSource.getMasterForCommittedTx(myLastCommittedTx).first();
            if (masterId == -1) {
                corrupted = true;
            }
        }
        catch (NoSuchLogVersionException e) {
            this.getMessageLog().logMessage("Missing log version " + e.getVersion() + " for transaction " + myLastCommittedTx + " and datasource " + dataSource.getName());
            corrupted = true;
            version = e.getVersion();
        }
        catch (IOException e) {
            this.getMessageLog().logMessage("IO exceptions while trying to retrieve the master for the latest txid (= " + myLastCommittedTx + " )", (Throwable)e);
        }
        catch (RuntimeException e) {
            this.getMessageLog().logMessage("Runtime exception while getting master id for for transaction " + myLastCommittedTx + " and datasource " + dataSource.getName(), (Throwable)e);
            corrupted = true;
            version = dataSource.getCurrentLogVersion() - 1L;
        }
        if (corrupted) {
            if (version != -1L) {
                this.getMessageLog().logMessage("Logical log file for transaction " + myLastCommittedTx + " not found.");
            } else {
                this.getMessageLog().logMessage("Tried to extract transaction " + myLastCommittedTx + " but it was not present in the log. Trying to retrieve it from master.");
            }
            if (copiedStore) {
                this.getMessageLog().logMessage("A store copy might be in progress. Will not act on the apparent corruption");
            } else {
                try {
                    this.copyLogFromMaster(this.broker.getMaster(), "nioneodb", version, myLastCommittedTx, myLastCommittedTx);
                    dataSource.getMasterForCommittedTx(myLastCommittedTx);
                    this.getMessageLog().logMessage("Log copy finished without problems");
                }
                catch (Exception e) {
                    this.getMessageLog().logMessage("Failed to retrieve log version " + version + " from master.", (Throwable)e);
                }
            }
        }
    }

    private void copyLogFromMaster(Pair<Master, Machine> master, String datasource, long logVersion, long startTxId, long endTxId) throws Exception {
        Response<Void> response = ((Master)master.first()).copyTransactions(this.emptyContext(), datasource, startTxId, endTxId);
        if (logVersion == -1L) {
            this.slaveOperations.receive(response);
            return;
        }
        XaDataSource ds = this.localGraph().getXaDataSourceManager().getXaDataSource(datasource);
        FileChannel newLog = this.localGraph().fileSystem.create(ds.getFileName(logVersion));
        newLog.truncate(0L);
        ByteBuffer scratch = ByteBuffer.allocate(64);
        LogIoUtils.writeLogHeader((ByteBuffer)scratch, (long)logVersion, (long)startTxId);
        newLog.write(scratch);
        ReadableByteChannel received = ((TxExtractor)((Triplet)response.transactions().next()).third()).extract();
        scratch.flip();
        while (received.read(scratch) > 0) {
            scratch.flip();
            newLog.write(scratch);
            scratch.flip();
        }
        newLog.force(false);
        newLog.close();
    }

    private void sleepWithoutInterruption(long time, String errorMessage) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(errorMessage, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStoreFromMaster(Pair<Master, Machine> master) throws Exception {
        this.getMessageLog().logMessage("Copying store from master");
        String temp = this.getClearedTempDir().getAbsolutePath();
        Response<Void> response = ((Master)master.first()).copyStore(this.emptyContext(), (StoreWriter)new ToFileStoreWriter(temp));
        long highestLogVersion = this.highestLogVersion(temp);
        if (highestLogVersion > -1L) {
            NeoStore.setVersion((String)temp, (long)(highestLogVersion + 1L));
        }
        GraphDatabaseAPI copiedDb = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(temp).setConfig((Setting)GraphDatabaseSettings.keep_logical_logs, "true").setConfig((Setting)GraphDatabaseSettings.allow_store_upgrade, ((Boolean)this.configuration.get((GraphDatabaseSetting)GraphDatabaseSettings.allow_store_upgrade)).toString()).newGraphDatabase();
        try {
            ServerUtil.applyReceivedTransactions(response, (GraphDatabaseAPI)copiedDb, (ServerUtil.TxHandler)ServerUtil.txHandlerForFullCopy());
        }
        finally {
            copiedDb.shutdown();
            response.close();
        }
        this.getMessageLog().logMessage("Done copying store from master");
    }

    private RequestContext emptyContext() {
        return new RequestContext(0L, this.machineId, 0, new RequestContext.Tx[0], 0, 0L);
    }

    private long highestLogVersion(String targetStoreDir) {
        return XaLogicalLog.getHighestHistoryLogVersion((File)new File(targetStoreDir), (String)"nioneo_logical.log");
    }

    private InternalAbstractGraphDatabase localGraph() {
        InternalAbstractGraphDatabase result = this.internalGraphDatabase;
        if (result != null) {
            return result;
        }
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.localGraphWait);
        while (result == null && System.currentTimeMillis() < endTime) {
            this.sleepWithoutInterruption(1L, "Failed waiting for local graph to be available");
            result = this.internalGraphDatabase;
        }
        if (result != null) {
            return result;
        }
        if (this.causeOfShutdown != null) {
            throw new DatabaseNotRunningException("Graph database not started", this.causeOfShutdown);
        }
        throw new DatabaseNotRunningException("Graph database not assigned and no cause of shutdown, maybe not started yet or in the middle of master/slave swap?", null);
    }

    public Broker getBroker() {
        return this.broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullUpdates() {
        block12: {
            try {
                if (this.masterServer != null) break block12;
                if (this.broker.getMaster() == null && this.broker instanceof ZooKeeperBroker) {
                    this.messageLog.logMessage("ZooKeeper broker returned null master");
                    this.newMaster(new NullPointerException("master returned from broker"));
                } else if (this.broker.getMaster().first() == null) {
                    this.newMaster(new NullPointerException("master returned from broker"));
                }
                RequestContext slaveContext = null;
                if (!this.pullUpdates) {
                    throw new NoMasterException();
                }
                HighlyAvailableGraphDatabase highlyAvailableGraphDatabase = this;
                synchronized (highlyAvailableGraphDatabase) {
                    if (!this.pullUpdates) {
                        return;
                    }
                    slaveContext = this.slaveOperations.getSlaveContext(-1);
                }
                this.slaveOperations.receive(((Master)this.broker.getMaster().first()).pullUpdates(slaveContext));
            }
            catch (ZooKeeperException e) {
                this.newMaster(e);
                throw e;
            }
            catch (NoMasterException e) {
                this.newMaster((Exception)((Object)e));
                throw e;
            }
            catch (ComException e) {
                throw e;
            }
        }
    }

    private void updateTime() {
        this.updateTime = System.currentTimeMillis();
    }

    long lastUpdateTime() {
        return this.updateTime;
    }

    public <T> Collection<T> getManagementBeans(Class<T> type) {
        return this.localGraph().getManagementBeans(type);
    }

    public boolean transactionRunning() {
        return this.localGraph().transactionRunning();
    }

    public final <T> T getManagementBean(Class<T> type) {
        return (T)this.localGraph().getManagementBean(type);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.storeDir + ", " + HaSettings.server_id.name() + ":" + this.machineId + "]";
    }

    protected synchronized void reevaluateMyself() {
        Pair<Master, Machine> master = this.broker.getMasterReally(true);
        boolean iAmCurrentlyMaster = this.masterServer != null;
        this.getMessageLog().logMessage("ReevaluateMyself: machineId=" + this.machineId + " with master[" + master + "] (I am master=" + iAmCurrentlyMaster + ", " + this.internalGraphDatabase + ")");
        this.pullUpdates = false;
        InternalAbstractGraphDatabase newDb = null;
        try {
            if (((Machine)master.other()).getMachineId() == this.machineId) {
                if (this.internalGraphDatabase == null || !iAmCurrentlyMaster) {
                    this.internalShutdown(true);
                    newDb = this.startAsMaster();
                }
                this.broker.rebindMaster();
            } else {
                this.broker.notifyMasterChange((Machine)master.other());
                if (this.internalGraphDatabase == null || iAmCurrentlyMaster) {
                    this.internalShutdown(true);
                    newDb = this.startAsSlave();
                } else {
                    ((SlaveGraphDatabase)this.internalGraphDatabase).forgetIdAllocationsFromMaster();
                }
            }
            if (this.masterServer == null) {
                this.instantiateAutoUpdatePullerIfConfigSaysSo();
                this.checkAndRecoverCorruptLogs(newDb != null ? newDb : this.internalGraphDatabase, false);
                this.ensureDataConsistencyWithMaster(newDb != null ? newDb : this.internalGraphDatabase, master);
                this.getMessageLog().logMessage("Data consistent with master");
            }
            if (newDb != null) {
                this.doAfterLocalGraphStarted(newDb);
                this.internalGraphDatabase = newDb;
            }
            this.pullUpdates = true;
        }
        catch (Throwable t) {
            this.safelyShutdownDb(newDb);
            throw Exceptions.launderedException((Throwable)t);
        }
    }

    private void safelyShutdownDb(InternalAbstractGraphDatabase newDb) {
        try {
            if (newDb != null) {
                newDb.shutdown();
            }
        }
        catch (Exception e) {
            this.messageLog.logMessage("Couldn't shut down newly started db", (Throwable)e);
        }
    }

    private void doAfterLocalGraphStarted(InternalAbstractGraphDatabase newDb) {
        this.broker.setConnectionInformation(newDb.getKernelData());
        for (TransactionEventHandler<?> transactionEventHandler : this.transactionEventHandlers) {
            newDb.registerTransactionEventHandler(transactionEventHandler);
        }
        for (KernelEventHandler kernelEventHandler : this.kernelEventHandlers) {
            newDb.registerKernelEventHandler(kernelEventHandler);
        }
    }

    private void logHaInfo(String started) {
        this.messageLog.logMessage(started, true);
        this.messageLog.logMessage("--- HIGH AVAILABILITY CONFIGURATION START ---");
        this.broker.logStatus(this.messageLog);
        this.messageLog.logMessage("--- HIGH AVAILABILITY CONFIGURATION END ---", true);
    }

    private InternalAbstractGraphDatabase startAsSlave() {
        this.messageLog.logMessage("Starting[" + this.machineId + "] as slave", true);
        SlaveGraphDatabase slaveGraphDatabase = new SlaveGraphDatabase(this.storeDir, this.configuration.getParams(), this.storeId, this, this.broker, this.logging, this.slaveOperations, this.slaveUpdateMode.createUpdater(this.broker), this.nodeLookup, this.relationshipLookups, this.fileSystemAbstraction, this.indexProviders, this.kernelExtensions, this.cacheProviders, this.caches);
        this.slaveServer = (SlaveServer)((Object)this.broker.instantiateSlaveServer(this, this.slaveOperations));
        this.logHaInfo("Started as slave");
        this.startupTime = System.currentTimeMillis();
        return slaveGraphDatabase;
    }

    protected InternalAbstractGraphDatabase startAsMaster() {
        this.messageLog.logMessage("Starting[" + this.machineId + "] as master", true);
        MasterGraphDatabase master = new MasterGraphDatabase(this.storeDir, this.configuration.getParams(), this.storeId, this, this.broker, this.logging, this.nodeLookup, this.relationshipLookups, this.indexProviders, this.kernelExtensions, this.cacheProviders, this.caches);
        this.masterServer = (MasterServer)((Object)this.broker.instantiateMasterServer((GraphDatabaseAPI)master));
        this.logHaInfo("Started as master");
        this.startupTime = System.currentTimeMillis();
        return master;
    }

    private void ensureDataConsistencyWithMaster(InternalAbstractGraphDatabase newDb, Pair<Master, Machine> master) {
        Pair mastersMaster;
        Pair myMaster;
        if (((Machine)master.other()).getMachineId() == this.machineId) {
            this.getMessageLog().logMessage("I am master so cannot consistency check data with master");
            return;
        }
        if (master.first() == null) {
            RuntimeException cause = new RuntimeException("Unable to get master from ZK");
            this.shutdown(cause, false);
            throw cause;
        }
        NeoStoreXaDataSource nioneoDataSource = newDb.getXaDataSourceManager().getNeoStoreDataSource();
        long myLastCommittedTx = nioneoDataSource.getLastCommittedTxId();
        try {
            myMaster = nioneoDataSource.getMasterForCommittedTx(myLastCommittedTx);
        }
        catch (NoSuchLogVersionException e) {
            this.getMessageLog().logMessage("Logical log file for txId " + myLastCommittedTx + " missing [version=" + e.getVersion() + "]. If this is startup then it will be recovered later, otherwise it might be a problem.");
            return;
        }
        catch (IOException e) {
            this.getMessageLog().logMessage("Failed to get master ID for txId " + myLastCommittedTx + ".", (Throwable)e);
            return;
        }
        catch (Exception e) {
            this.getMessageLog().logMessage("Exception while getting master ID for txId " + myLastCommittedTx + ".", (Throwable)e);
            throw new BranchedDataException("Maybe not branched data, but it could solve it", e);
        }
        Response<Pair<Integer, Long>> response = null;
        try {
            response = ((Master)master.first()).getMasterIdForCommittedTx(myLastCommittedTx, newDb.getStoreId());
            mastersMaster = (Pair)response.response();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof NoSuchLogVersionException) {
                throw new BranchedDataException("Maybe not branched data, but it could solve it", e.getCause());
            }
            throw e;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        if ((Integer)myMaster.first() != -1 && !myMaster.equals((Object)mastersMaster)) {
            String msg = "Branched data, I (machineId:" + this.machineId + ") think machineId for txId (" + myLastCommittedTx + ") is " + myMaster + ", but master (machineId:" + ((Machine)master.other()).getMachineId() + ") says that it's " + mastersMaster;
            this.getMessageLog().logMessage(msg, true);
            BranchedDataException exception = new BranchedDataException(msg);
            this.safelyShutdownDb(newDb);
            this.shutdown(exception, false);
            throw exception;
        }
        this.getMessageLog().logMessage("Master id for last committed tx ok with highestTxId=" + myLastCommittedTx + " with masterId=" + myMaster, true);
    }

    private void instantiateAutoUpdatePullerIfConfigSaysSo() {
        long pullInterval = this.configuration.getDuration(HaSettings.pull_interval);
        if (pullInterval > 0L && this.updatePuller == null) {
            this.updatePuller = new ScheduledThreadPoolExecutor(1);
            this.updatePuller.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (!HighlyAvailableGraphDatabase.this.pullUpdates) {
                        return;
                    }
                    try {
                        HighlyAvailableGraphDatabase.this.pullUpdates();
                    }
                    catch (Exception e) {
                        HighlyAvailableGraphDatabase.this.messageLog.logMessage("Pull updates failed", (Throwable)e);
                    }
                }
            }, pullInterval, pullInterval, TimeUnit.MILLISECONDS);
        }
    }

    public TransactionBuilder tx() {
        return this.localGraph().tx();
    }

    public synchronized void internalShutdown(boolean rotateLogs) {
        this.messageLog.logMessage("Internal shutdown of HA db[" + this.machineId + "] reference=" + (Object)((Object)this) + ", masterServer=" + (Object)((Object)this.masterServer), (Throwable)new InformativeStackTrace("Internal shutdown"), true);
        this.pullUpdates = false;
        if (this.updatePuller != null) {
            this.messageLog.logMessage("Internal shutdown updatePuller", true);
            try {
                this.updatePuller.shutdown();
                this.updatePuller.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.messageLog.logMessage("Got exception while waiting for update puller termination", (Throwable)e, true);
            }
            this.messageLog.logMessage("Internal shutdown updatePuller DONE", true);
            this.updatePuller = null;
        }
        if (this.masterServer != null) {
            this.messageLog.logMessage("Internal shutdown masterServer", true);
            this.masterServer.shutdown();
            this.messageLog.logMessage("Internal shutdown masterServer DONE", true);
            this.masterServer = null;
        }
        if (this.slaveServer != null) {
            this.slaveServer.shutdown();
            this.slaveServer = null;
        }
        if (this.internalGraphDatabase != null) {
            InternalAbstractGraphDatabase localRefToInternalDb = this.internalGraphDatabase;
            this.internalGraphDatabase = null;
            if (rotateLogs) {
                localRefToInternalDb.getXaDataSourceManager().rotateLogicalLogs();
            }
            this.messageLog.logMessage("Internal shutdown localGraph", true);
            localRefToInternalDb.shutdown();
            this.messageLog.logMessage("Internal shutdown localGraph DONE", true);
        }
        this.messageLog.flush();
    }

    private synchronized void shutdown(Throwable cause, boolean shutdownBroker) {
        this.causeOfShutdown = cause;
        this.messageLog.logMessage("Shutdown[" + this.machineId + "], " + (Object)((Object)this), true);
        if (shutdownBroker && this.broker != null) {
            this.broker.shutdown();
        }
        this.internalShutdown(false);
        this.life.shutdown();
    }

    protected synchronized void close() {
        this.shutdown(new IllegalStateException("shutdown called"), true);
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        this.kernelEventHandlers.add(handler);
        return this.localGraph().registerKernelEventHandler(handler);
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.transactionEventHandlers.add(handler);
        return this.localGraph().registerTransactionEventHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        try {
            KernelEventHandler kernelEventHandler = this.localGraph().unregisterKernelEventHandler(handler);
            return kernelEventHandler;
        }
        finally {
            this.kernelEventHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        try {
            TransactionEventHandler transactionEventHandler = this.localGraph().unregisterTransactionEventHandler(handler);
            return transactionEventHandler;
        }
        finally {
            this.transactionEventHandlers.remove(handler);
        }
    }

    private synchronized void newMaster(Exception e) {
        if (e instanceof ComException && e.getCause() instanceof BranchedDataException) {
            BranchedDataException bde = (BranchedDataException)e.getCause();
            this.getMessageLog().logMessage("Master says I've got branched data: " + bde);
        }
        Throwable cause = null;
        int i = 0;
        boolean unexpectedException = false;
        while (i++ < 3) {
            try {
                this.getMessageLog().logMessage("newMaster called", e, true);
                this.reevaluateMyself();
                return;
            }
            catch (ZooKeeperException zke) {
                this.getMessageLog().logMessage("ZooKeeper exception in newMaster, retry #" + i, (Throwable)zke);
                e = zke;
                cause = zke;
                this.sleepWithoutInterruption(500L, "");
            }
            catch (IllegalProtocolVersionException pe) {
                this.getMessageLog().logMessage("Got wrong protocol version during newMaster, expected " + pe.getExpected() + " but got " + pe.getReceived(), e);
                this.broker.restart();
                e = pe;
                cause = pe;
            }
            catch (ComException ce) {
                this.getMessageLog().logMessage("Communication exception in newMaster, retry #" + i, (Throwable)ce);
                e = ce;
                cause = ce;
                this.sleepWithoutInterruption(500L, "");
            }
            catch (BranchedDataException bde) {
                this.getMessageLog().logMessage("Branched data occurred, during newMaster retry #" + i, (Throwable)bde);
                this.getFreshDatabaseFromMaster(true);
                e = bde;
                cause = bde;
            }
            catch (Throwable t) {
                cause = t;
                unexpectedException = true;
                break;
            }
        }
        if (cause != null && unexpectedException) {
            this.getMessageLog().logMessage("Reevaluation ended in unknown exception " + cause + " so shutting down", cause, true);
            this.shutdown(cause, false);
        }
        throw Exceptions.launderedException(cause);
    }

    public MasterServer getMasterServerIfMaster() {
        return this.masterServer;
    }

    protected int getMachineId() {
        return this.machineId;
    }

    public boolean isMaster() {
        return this.getMasterServerIfMaster() != null;
    }

    protected Broker createBroker() {
        return new ZooKeeperBroker(this.configuration, new ZooClientFactory(){

            @Override
            public ZooClient newZooClient() {
                return new ZooClient(HighlyAvailableGraphDatabase.this.storeDir, HighlyAvailableGraphDatabase.this.messageLog, HighlyAvailableGraphDatabase.this.configuration, HighlyAvailableGraphDatabase.this.slaveOperations, HighlyAvailableGraphDatabase.this.slaveOperations, HighlyAvailableGraphDatabase.this.masterClientResolver);
            }
        });
    }

    protected ClusterClient createClusterClient() {
        return this.defaultClusterClient();
    }

    private ClusterClient defaultClusterClient() {
        return new ZooKeeperClusterClient((String)this.configuration.get((GraphDatabaseSetting)HaSettings.coordinators), this.getMessageLog(), (String)this.configuration.get((GraphDatabaseSetting)HaSettings.cluster_name), this.configuration.getInteger(HaSettings.zk_session_timeout), this.masterClientResolver);
    }

    public String getStoreDir() {
        return this.storeDir;
    }

    public DependencyResolver getDependencyResolver() {
        return this.haDependencyResolver;
    }

    public KernelPanicEventGenerator getKernelPanicGenerator() {
        return this.localGraph().getKernelPanicGenerator();
    }

    public PersistenceSource getPersistenceSource() {
        return this.localGraph().getPersistenceSource();
    }

    public Guard getGuard() {
        return this.localGraph().getGuard();
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    private class HARelationshipLookups
    implements RelationshipProxy.RelationshipLookups {
        private HARelationshipLookups() {
        }

        public Node lookupNode(long nodeId) {
            return HighlyAvailableGraphDatabase.this.localGraph().getNodeManager().getNodeById(nodeId);
        }

        public RelationshipImpl lookupRelationship(long relationshipId) {
            return HighlyAvailableGraphDatabase.this.localGraph().getNodeManager().getRelationshipForProxy(relationshipId, null);
        }

        public RelationshipImpl lookupRelationship(long relationshipId, LockType lock) {
            return HighlyAvailableGraphDatabase.this.localGraph().getNodeManager().getRelationshipForProxy(relationshipId, lock);
        }

        public GraphDatabaseService getGraphDatabaseService() {
            return HighlyAvailableGraphDatabase.this;
        }

        public NodeManager getNodeManager() {
            return HighlyAvailableGraphDatabase.this.localGraph().getNodeManager();
        }

        public Node newNodeProxy(long nodeId) {
            return HighlyAvailableGraphDatabase.this.localGraph().getNodeManager().newNodeProxyById(nodeId);
        }
    }

    private class HANodeLookup
    implements NodeProxy.NodeLookup {
        private HANodeLookup() {
        }

        public NodeImpl lookup(long nodeId) {
            return HighlyAvailableGraphDatabase.this.localGraph().getNodeManager().getNodeForProxy(nodeId, null);
        }

        public NodeImpl lookup(long nodeId, LockType lock) {
            return HighlyAvailableGraphDatabase.this.localGraph().getNodeManager().getNodeForProxy(nodeId, lock);
        }

        public GraphDatabaseService getGraphDatabase() {
            return HighlyAvailableGraphDatabase.this;
        }

        public NodeManager getNodeManager() {
            return HighlyAvailableGraphDatabase.this.localGraph().getNodeManager();
        }
    }

    private class TxManagerCheckKernelEventHandler
    implements KernelEventHandler {
        private TxManagerCheckKernelEventHandler() {
        }

        public void beforeShutdown() {
        }

        public void kernelPanic(ErrorState error) {
            if (error == ErrorState.TX_MANAGER_NOT_OK) {
                HighlyAvailableGraphDatabase.this.messageLog.logMessage("TxManager not ok, doing internal restart");
                HighlyAvailableGraphDatabase.this.internalShutdown(true);
                HighlyAvailableGraphDatabase.this.newMaster(new InformativeStackTrace("Tx manager not ok"));
            }
        }

        public Object getResource() {
            return null;
        }

        public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
            return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
        }
    }

    class LocalDatabaseOperations
    implements SlaveDatabaseOperations,
    ClusterEventReceiver {
        LocalDatabaseOperations() {
        }

        @Override
        public RequestContext getSlaveContext(int eventIdentifier) {
            try {
                XaDataSourceManager localDataSourceManager = HighlyAvailableGraphDatabase.this.getXaDataSourceManager();
                Collection dataSources = localDataSourceManager.getAllRegisteredDataSources();
                RequestContext.Tx[] txs = new RequestContext.Tx[dataSources.size()];
                int i = 0;
                Pair master = null;
                for (XaDataSource dataSource : dataSources) {
                    long txId = dataSource.getLastCommittedTxId();
                    if (dataSource.getName().equals("nioneodb")) {
                        master = dataSource.getMasterForCommittedTx(txId);
                    }
                    txs[i++] = RequestContext.lastAppliedTx((String)dataSource.getName(), (long)txId);
                }
                return new RequestContext(HighlyAvailableGraphDatabase.this.startupTime, HighlyAvailableGraphDatabase.this.machineId, eventIdentifier, txs, ((Integer)master.first()).intValue(), ((Long)master.other()).longValue());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public <T> T receive(Response<T> response) {
            try {
                ServerUtil.applyReceivedTransactions(response, (GraphDatabaseAPI)HighlyAvailableGraphDatabase.this, (ServerUtil.TxHandler)ServerUtil.NO_ACTION);
                HighlyAvailableGraphDatabase.this.updateTime();
                Object object = response.response();
                return (T)object;
            }
            catch (IOException e) {
                this.newMaster(e);
                throw new RuntimeException(e);
            }
            finally {
                response.close();
            }
        }

        public void handle(Exception e) {
            this.newMaster(e);
        }

        @Override
        public void exceptionHappened(RuntimeException e) {
            if (e instanceof ZooKeeperException || e instanceof ComException) {
                HighlyAvailableGraphDatabase.this.slaveOperations.newMaster(e);
                throw e;
            }
        }

        @Override
        public void newMaster(Exception e) {
            HighlyAvailableGraphDatabase.this.newMaster(e);
        }

        @Override
        public synchronized void reconnect(Exception e) {
            if (HighlyAvailableGraphDatabase.this.broker != null) {
                HighlyAvailableGraphDatabase.this.broker.restart();
            }
            this.newMaster(e);
        }

        @Override
        public int getMasterForTx(long tx) {
            try {
                return (Integer)HighlyAvailableGraphDatabase.this.localGraph().getXaDataSourceManager().getNeoStoreDataSource().getMasterForCommittedTx(tx).first();
            }
            catch (IOException e) {
                throw new ComException("Master id not found for tx:" + tx, (Throwable)e);
            }
        }
    }

    public static enum BranchedDataPolicy {
        keep_all{

            @Override
            void handle(HighlyAvailableGraphDatabase db) {
                this.moveAwayDb(db, this.newBranchedDataDir(db));
            }
        }
        ,
        keep_last{

            @Override
            void handle(HighlyAvailableGraphDatabase db) {
                File branchedDataDir = this.newBranchedDataDir(db);
                this.moveAwayDb(db, branchedDataDir);
                for (File file : 2.getBranchedDataRootDirectory(db.getStoreDir()).listFiles()) {
                    if (!2.isBranchedDataDirectory(file) || file.equals(branchedDataDir)) continue;
                    try {
                        FileUtils.deleteRecursively((File)file);
                    }
                    catch (IOException e) {
                        db.messageLog.logMessage("Couldn't delete old branched data directory " + file, (Throwable)e);
                    }
                }
            }
        }
        ,
        keep_none{

            @Override
            void handle(HighlyAvailableGraphDatabase db) {
                for (File file : this.relevantDbFiles(db)) {
                    try {
                        FileUtils.deleteRecursively((File)file);
                    }
                    catch (IOException e) {
                        db.messageLog.logMessage("Couldn't delete file " + file, (Throwable)e);
                    }
                }
            }
        }
        ,
        shutdown{

            @Override
            void handle(HighlyAvailableGraphDatabase db) {
                db.shutdown();
            }
        };

        static String BRANCH_SUBDIRECTORY;

        abstract void handle(HighlyAvailableGraphDatabase var1);

        protected void moveAwayDb(HighlyAvailableGraphDatabase db, File branchedDataDir) {
            for (File file : this.relevantDbFiles(db)) {
                try {
                    FileUtils.moveFileToDirectory((File)file, (File)branchedDataDir);
                }
                catch (IOException e) {
                    db.messageLog.logMessage("Couldn't move " + file.getPath());
                }
            }
        }

        File newBranchedDataDir(HighlyAvailableGraphDatabase db) {
            File result = BranchedDataPolicy.getBranchedDataDirectory(db.getStoreDir(), System.currentTimeMillis());
            result.mkdirs();
            return result;
        }

        File[] relevantDbFiles(HighlyAvailableGraphDatabase db) {
            if (!new File(db.getStoreDir()).exists()) {
                return new File[0];
            }
            return new File(db.getStoreDir()).listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !file.getName().equals("messages.log") && !BranchedDataPolicy.isBranchedDataRootDirectory(file);
                }
            });
        }

        public static boolean isBranchedDataRootDirectory(File directory) {
            return directory.isDirectory() && directory.getName().equals(BRANCH_SUBDIRECTORY);
        }

        public static boolean isBranchedDataDirectory(File directory) {
            return directory.isDirectory() && directory.getParentFile().getName().equals(BRANCH_SUBDIRECTORY) && BranchedDataPolicy.isAllDigits(directory.getName());
        }

        private static boolean isAllDigits(String string) {
            for (char c : string.toCharArray()) {
                if (Character.isDigit(c)) continue;
                return false;
            }
            return true;
        }

        public static File getBranchedDataRootDirectory(String dbStoreDir) {
            return new File(dbStoreDir, BRANCH_SUBDIRECTORY);
        }

        public static File getBranchedDataDirectory(String dbStoreDir, long timestamp) {
            return new File(BranchedDataPolicy.getBranchedDataRootDirectory(dbStoreDir), "" + timestamp);
        }

        public static File[] listBranchedDataDirectories(String storeDir) {
            return BranchedDataPolicy.getBranchedDataRootDirectory(storeDir).listFiles(new FileFilter(){

                @Override
                public boolean accept(File directory) {
                    return BranchedDataPolicy.isBranchedDataDirectory(directory);
                }
            });
        }

        static {
            BRANCH_SUBDIRECTORY = "branched";
        }
    }
}

