/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import javax.transaction.TransactionManager;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.TxExtractor;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.SlaveDatabaseOperations;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class SlaveTxIdGenerator
implements TxIdGenerator {
    private final Broker broker;
    private final SlaveDatabaseOperations databaseOperations;
    private final TxManager txManager;

    public SlaveTxIdGenerator(Broker broker, SlaveDatabaseOperations databaseOperations, TransactionManager txManager) {
        this.broker = broker;
        this.databaseOperations = databaseOperations;
        this.txManager = (TxManager)txManager;
    }

    public long generate(final XaDataSource dataSource, final int identifier) {
        try {
            int eventIdentifier = this.txManager.getEventIdentifier();
            Response<Long> response = ((Master)this.broker.getMaster().first()).commitSingleResourceTransaction(ServerUtil.onlyIncludeResource((RequestContext)this.databaseOperations.getSlaveContext(eventIdentifier), (XaDataSource)dataSource), dataSource.getName(), new TxExtractor(){

                public void extract(LogBuffer buffer) {
                    try {
                        dataSource.getPreparedTransaction(identifier, buffer);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public ReadableByteChannel extract() {
                    try {
                        return dataSource.getPreparedTransaction(identifier);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            return this.databaseOperations.receive(response);
        }
        catch (RuntimeException e) {
            this.databaseOperations.exceptionHappened(e);
            throw e;
        }
    }

    public int getCurrentMasterId() {
        return ((Machine)this.broker.getMaster().other()).getMachineId();
    }

    public int getMyId() {
        return this.broker.getMyMachineId();
    }

    public void committed(XaDataSource dataSource, int identifier, long txId, Integer externalAuthorServerId) {
        ((Master)this.broker.getMaster().first()).pushTransaction(this.databaseOperations.getSlaveContext(identifier), dataSource.getName(), txId).close();
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
    }

    public void stop() throws Throwable {
    }

    public void shutdown() throws Throwable {
    }

    public static class SlaveTxIdGeneratorFactory
    implements TxIdGeneratorFactory {
        private final Broker broker;
        private final SlaveDatabaseOperations databaseOperations;

        public SlaveTxIdGeneratorFactory(Broker broker, SlaveDatabaseOperations databaseOperations) {
            this.broker = broker;
            this.databaseOperations = databaseOperations;
        }

        public TxIdGenerator create(TransactionManager txManager) {
            return new SlaveTxIdGenerator(this.broker, this.databaseOperations, txManager);
        }
    }
}

