/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.ha.ClusterManager;

public class PullStormIT {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    @Rule
    public LoggerRule logger = new LoggerRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPullStorm() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterWithAdditionalArbiters(2, 1), this.folder.getRoot(), MapUtil.stringMap((String[])new String[]{HaSettings.pull_interval.name(), "0", HaSettings.tx_push_factor.name(), "1"}));
        clusterManager.start();
        try {
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
            final HighlyAvailableGraphDatabase master = cluster.getMaster();
            System.out.println("Creating data");
            Transaction tx = master.beginTx();
            for (int i = 0; i < 1000; ++i) {
                master.createNode().setProperty("foo", (Object)"bar");
            }
            tx.success();
            tx.finish();
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            System.out.println("Slave failed");
            ClusterManager.RepairKit repairKit = cluster.fail(slave);
            System.out.println("Creating more data");
            for (int i = 0; i < 1000; ++i) {
                Transaction tx2 = master.beginTx();
                for (int j = 0; j < 1000; ++j) {
                    master.createNode().setProperty("foo", (Object)"bar");
                    master.createNode().setProperty("foo", (Object)"bar");
                }
                tx2.success();
                tx2.finish();
            }
            System.out.println("Slave comes up");
            repairKit.repair();
            cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
            System.out.println("Pull storm");
            ExecutorService executor = Executors.newFixedThreadPool(20);
            ArrayList result = new ArrayList();
            for (int i = 0; i < 20; ++i) {
                result.add(executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        Transaction tx = master.beginTx();
                        master.createNode().setProperty("foo", (Object)"bar");
                        tx.success();
                        tx.finish();
                    }
                }));
            }
            for (Future future : result) {
                future.get();
            }
            executor.shutdown();
            System.out.println("Pull storm done");
            for (HighlyAvailableGraphDatabase highlyAvailableGraphDatabase : cluster.getAllMembers()) {
                long txId = ((NeoStoreXaDataSource)((XaDataSourceManager)highlyAvailableGraphDatabase.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getXaDataSource("nioneodb")).getNeoStore().getLastCommittedTx();
                System.out.println(highlyAvailableGraphDatabase.getConfig().get(ClusterSettings.server_id) + "=" + txId);
            }
        }
        finally {
            System.err.println("Shutting down");
            clusterManager.shutdown();
            System.err.println("Shut down");
        }
    }
}

