/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class TestBasicHaOperations {
    @Rule
    public LoggerRule logger = new LoggerRule();
    public TargetDirectory dir = TargetDirectory.forTest(this.getClass());
    private ClusterManager clusterManager;

    @After
    public void after() throws Throwable {
        if (this.clusterManager != null) {
            this.clusterManager.stop();
            this.clusterManager = null;
        }
    }

    @Test
    public void testBasicFailover() throws Throwable {
        this.clusterManager = new ClusterManager(ClusterManager.clusterOfSize(3), this.dir.directory("failover", true), MapUtil.stringMap((String[])new String[0]));
        this.clusterManager.start();
        ClusterManager.ManagedCluster cluster = this.clusterManager.getDefaultCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(slave1);
        long start = System.nanoTime();
        cluster.shutdown(master);
        this.logger.getLogger().warn("Shut down master");
        cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        long end = System.nanoTime();
        this.logger.getLogger().warn("Failover took:" + (end - start) / 1000000L + "ms");
        boolean slave1Master = slave1.isMaster();
        boolean slave2Master = slave2.isMaster();
        if (slave1Master) {
            Assert.assertFalse((boolean)slave2Master);
        } else {
            Assert.assertTrue((boolean)slave2Master);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicPropagationFromSlaveToMaster() throws Throwable {
        this.clusterManager = new ClusterManager(ClusterManager.clusterOfSize(3), this.dir.directory("propagation", true), MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2"}));
        this.clusterManager.start();
        ClusterManager.ManagedCluster cluster = this.clusterManager.getDefaultCluster();
        long nodeId = 0L;
        Transaction tx = null;
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try {
            tx = slave.beginTx();
            Node node = slave.createNode();
            node.setProperty("Hello", (Object)"World");
            nodeId = node.getId();
            tx.success();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            junit.framework.Assert.fail();
        }
        finally {
            tx.finish();
        }
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        String value = master.getNodeById(nodeId).getProperty("Hello").toString();
        this.logger.getLogger().info("Hello=" + value);
        Assert.assertEquals((Object)"World", (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicPropagationFromMasterToSlave() throws Throwable {
        this.clusterManager = new ClusterManager(ClusterManager.clusterOfSize(3), this.dir.directory("propagation", true), MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2"}));
        this.clusterManager.start();
        ClusterManager.ManagedCluster cluster = this.clusterManager.getDefaultCluster();
        long nodeId = 0L;
        Transaction tx = null;
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try {
            tx = master.beginTx();
            Node node = master.createNode();
            node.setProperty("Hello", (Object)"World");
            nodeId = node.getId();
            tx.success();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            junit.framework.Assert.fail();
        }
        finally {
            tx.finish();
        }
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        String value = slave1.getNodeById(nodeId).getProperty("Hello").toString();
        this.logger.getLogger().info("Hello=" + value);
        Assert.assertEquals((Object)"World", (Object)value);
        HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(slave1);
        value = slave2.getNodeById(nodeId).getProperty("Hello").toString();
        this.logger.getLogger().info("Hello=" + value);
        Assert.assertEquals((Object)"World", (Object)value);
    }
}

