/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.neo4j.graphdb.TransactionFailureException;

public class DelegateInvocationHandler<T>
implements InvocationHandler {
    private volatile T delegate;

    public void setDelegate(T delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.delegate == null) {
            throw new TransactionFailureException("Instance state changed after this transaction started.");
        }
        try {
            return method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static <T> T snapshot(T proxiedInstance) {
        DelegateInvocationHandler delegateHandler = (DelegateInvocationHandler)Proxy.getInvocationHandler(proxiedInstance);
        return delegateHandler.delegate;
    }
}

