/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.neo4j.com.ComException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.InstanceAccessGuard;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class UpdatePuller
implements Lifecycle {
    private final HaXaDataSourceManager xaDataSourceManager;
    private final Master master;
    private final RequestContextFactory requestContextFactory;
    private final AbstractTransactionManager txManager;
    private final InstanceAccessGuard accessGuard;
    private final LastUpdateTime lastUpdateTime;
    private final Config config;
    private final StringLogger logger;
    private boolean pullUpdates = false;
    private ScheduledThreadPoolExecutor updatePuller;

    public UpdatePuller(HaXaDataSourceManager xaDataSourceManager, Master master, RequestContextFactory requestContextFactory, AbstractTransactionManager txManager, InstanceAccessGuard accessGuard, LastUpdateTime lastUpdateTime, Config config, StringLogger logger) {
        this.xaDataSourceManager = xaDataSourceManager;
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.txManager = txManager;
        this.accessGuard = accessGuard;
        this.lastUpdateTime = lastUpdateTime;
        this.config = config;
        this.logger = logger;
    }

    public void pullUpdates() {
        if (this.accessGuard.await(5000L)) {
            this.xaDataSourceManager.applyTransactions(this.master.pullUpdates(this.requestContextFactory.newRequestContext(this.txManager.getEventIdentifier())));
        }
        this.lastUpdateTime.setLastUpdateTime(System.currentTimeMillis());
    }

    public void init() throws Throwable {
        long pullInterval = (Long)this.config.get(HaSettings.pull_interval);
        if (pullInterval > 0L && this.updatePuller == null) {
            this.updatePuller = new ScheduledThreadPoolExecutor(1);
            this.updatePuller.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (!UpdatePuller.this.pullUpdates) {
                        return;
                    }
                    try {
                        UpdatePuller.this.pullUpdates();
                    }
                    catch (ComException e) {
                    }
                    catch (Exception e) {
                        UpdatePuller.this.logger.logMessage("Pull updates failed", (Throwable)e);
                    }
                }
            }, pullInterval, pullInterval, TimeUnit.MILLISECONDS);
        }
        this.pullUpdates = false;
    }

    public void start() throws Throwable {
        this.pullUpdates = true;
    }

    public void stop() throws Throwable {
        this.pullUpdates = false;
    }

    public void shutdown() throws Throwable {
        if (this.updatePuller != null) {
            try {
                this.updatePuller.shutdown();
                this.updatePuller.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.logger.logMessage("Got exception while waiting for update puller termination", (Throwable)e, true);
            }
        }
    }
}

