/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.master.SlaveClient;
import org.neo4j.kernel.ha.com.master.SlaveFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.DataSourceRegistrationListener;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.logging.Logging;

public class DefaultSlaveFactory
implements SlaveFactory {
    private final Logging logging;
    private final int chunkSize;
    private StoreId storeId;

    public DefaultSlaveFactory(XaDataSourceManager xaDsm, Logging logging, int chunkSize) {
        this.logging = logging;
        this.chunkSize = chunkSize;
        xaDsm.addDataSourceRegistrationListener((DataSourceRegistrationListener)new StoreIdSettingListener());
    }

    @Override
    public Slave newSlave(ClusterMember clusterMember) {
        return new SlaveClient(clusterMember.getInstanceId(), clusterMember.getHAUri().getHost(), clusterMember.getHAUri().getPort(), this.logging, this.storeId, 2, this.chunkSize);
    }

    private class StoreIdSettingListener
    extends DataSourceRegistrationListener.Adapter {
        private StoreIdSettingListener() {
        }

        public void registeredDataSource(XaDataSource ds) {
            if (ds instanceof NeoStoreXaDataSource) {
                DefaultSlaveFactory.this.storeId = ((NeoStoreXaDataSource)ds).getStoreId();
            }
        }
    }
}

