/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.net.URI;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.cluster.AbstractModeSwitcher;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.transaction.MasterTxHook;
import org.neo4j.kernel.ha.transaction.SlaveTxHook;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.TxHook;

public class TxHookModeSwitcher
extends AbstractModeSwitcher<TxHook> {
    private final Master master;
    private final RequestContextFactoryResolver requestContextFactory;
    private final DependencyResolver resolver;

    public TxHookModeSwitcher(HighAvailabilityMemberStateMachine stateMachine, DelegateInvocationHandler<TxHook> delegate, Master master, RequestContextFactoryResolver requestContextFactory, DependencyResolver resolver) {
        super(stateMachine, delegate);
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.resolver = resolver;
    }

    @Override
    protected TxHook getMasterImpl() {
        return new MasterTxHook();
    }

    @Override
    protected TxHook getSlaveImpl(URI serverHaUri) {
        return new SlaveTxHook(this.master, (HaXaDataSourceManager)((Object)this.resolver.resolveDependency(HaXaDataSourceManager.class)), this.requestContextFactory, (AbstractTransactionManager)this.resolver.resolveDependency(TransactionManager.class));
    }

    public static interface RequestContextFactoryResolver {
        public RequestContextFactory get();
    }
}

