/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.upgrade;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.ha.upgrade.LegacyDatabase;
import org.neo4j.ha.upgrade.LegacyDatabaseImpl;
import org.neo4j.ha.upgrade.Utils;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.test.TargetDirectory;
import org.neo4j.tooling.GlobalGraphOperations;

@Ignore
public class RollingUpgradeIT {
    private TargetDirectory DIR = TargetDirectory.forTest(this.getClass());
    private File DBS_DIR = this.DIR.directory("dbs", true);
    private Process zoo;
    private LegacyDatabase[] legacyDbs;
    private GraphDatabaseAPI[] newDbs;

    @Test
    public void doRollingUpgradeFromOneEightToOneNineWithMasterLast() throws Throwable {
        try {
            this.startOneEightCluster();
            this.rollOverToOneNine();
            this.verify();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void debug(String message) {
        this.debug(message, true);
    }

    private void debug(String message, boolean enter) {
        String string = "RUT " + message;
        if (enter) {
            System.out.println(string);
        } else {
            System.out.print(string);
        }
    }

    @After
    public void cleanUp() throws Exception {
        if (this.legacyDbs != null) {
            for (LegacyDatabase legacyDatabase : this.legacyDbs) {
                this.stop(legacyDatabase);
            }
        }
        if (this.newDbs != null) {
            for (LegacyDatabase legacyDatabase : this.newDbs) {
                legacyDatabase.shutdown();
            }
        }
        if (this.zoo != null) {
            this.zoo.destroy();
        }
    }

    private void startOneEightCluster() throws Exception {
        this.debug("Downloading 1.8 package");
        File oneEightPackage = Utils.downloadAndUnpack("http://download.neo4j.org/artifact?edition=enterprise&version=1.8&distribution=zip", this.DIR.directory("download"), "1.8-enterprise");
        String classpath = Utils.assembleClassPathFromPackage(oneEightPackage);
        this.debug("Starting zoo");
        this.zoo = this.startZoo(classpath);
        this.debug("Starting 1.8 cluster in separate jvms");
        this.legacyDbs = new LegacyDatabase[3];
        for (int i = 0; i < this.legacyDbs.length; ++i) {
            this.legacyDbs[i] = LegacyDatabaseImpl.start(classpath, new File(this.DBS_DIR, "" + i), this.config(i, true));
            this.debug("  Started " + i);
        }
        for (LegacyDatabase db : this.legacyDbs) {
            this.debug("  Awaiting " + db.getStoreDir() + " to start");
            db.awaitStarted(10L, TimeUnit.SECONDS);
            this.debug("  " + db.getStoreDir() + " fully started");
        }
        for (int i = 0; i < this.legacyDbs.length; ++i) {
            String name = "initial-" + i;
            long node = this.legacyDbs[i].createNode(name);
            for (LegacyDatabase db : this.legacyDbs) {
                db.verifyNodeExists(node, name);
            }
        }
        this.debug("1.8 cluster fully operational");
    }

    private Map<String, String> config(int serverId, boolean forOneEight) throws UnknownHostException {
        String localhost = InetAddress.getLocalHost().getHostAddress();
        Map result = MapUtil.stringMap((String[])new String[]{ClusterSettings.server_id.name(), "" + serverId, HaSettings.ha_server.name(), localhost + ":" + (6000 + serverId), ClusterSettings.cluster_server.name(), localhost + ":" + (5000 + serverId), "ha.coordinators", "localhost:2181", HaSettings.coordinators.name(), "localhost:2181", ClusterSettings.initial_hosts.name(), localhost + ":" + 5000 + "," + localhost + ":" + 5001 + "," + localhost + ":" + 5002});
        return result;
    }

    private Process startZoo(String classpath) throws Exception {
        return Utils.execJava(classpath, "org.apache.zookeeper.server.quorum.QuorumPeerMain", Utils.zkConfig(this.DIR, 1, 2181));
    }

    private void rollOverToOneNine() throws Exception {
        this.debug("Starting to roll over to 1.9");
        this.newDbs = new GraphDatabaseAPI[this.legacyDbs.length];
        for (int i = this.legacyDbs.length - 1; i >= 0; --i) {
            int j;
            LegacyDatabase legacyDb = this.legacyDbs[i];
            String storeDir = legacyDb.getStoreDir();
            this.stop(legacyDb);
            Thread.sleep(15000L);
            this.debug("Starting it as 1.9");
            this.newDbs[i] = (GraphDatabaseAPI)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(storeDir).setConfig(this.config(i, false)).newGraphDatabase();
            this.debug("Started as 1.9");
            String name = "upgraded-" + i;
            long node = this.createNodeWithRetry((GraphDatabaseService)this.newDbs[i], name);
            System.out.println("===> Created on " + i);
            for (j = 0; j < i; ++j) {
                this.legacyDbs[j].verifyNodeExists(node, name);
                this.debug("Verified on legacy db " + j);
            }
            for (j = i; j < this.newDbs.length; ++j) {
                this.verifyNodeExists(this.newDbs[j], node, name);
                this.debug("==> Verified on new db " + j);
            }
        }
    }

    private void stop(LegacyDatabase legacyDb) {
        try {
            legacyDb.stop();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void verify() {
    }

    private long createNodeWithRetry(GraphDatabaseService db, String name) throws InterruptedException {
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(120L);
        Exception exception = null;
        while (System.currentTimeMillis() < end) {
            try {
                return this.createNode(db, name);
            }
            catch (Exception e) {
                exception = e;
                this.debug("Master not switched yet, retrying in a jiffy (" + e + ")");
                Thread.sleep(1024L);
            }
        }
        throw Exceptions.launderedException(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createNode(GraphDatabaseService db, String name) {
        Transaction tx = db.beginTx();
        try {
            Node node = db.createNode();
            node.setProperty("name", (Object)name);
            tx.success();
            long l = node.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    private void verifyNodeExists(GraphDatabaseAPI db, long id, String name) {
        ((UpdatePuller)db.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
        for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
            if (!name.equals(node.getProperty("name", null))) continue;
            return;
        }
        Assert.fail((String)("Node " + id + " with name '" + name + "' not found"));
    }
}

