/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.List;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Function2;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.Settings;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.EnterpriseConfigurationMigrator;
import org.neo4j.kernel.impl.cache.GcrSettings;

public class HaSettings {
    @Migrator
    public static final ConfigurationMigrator migrator = new EnterpriseConfigurationMigrator();
    @Description(value="Timeout for reading network data")
    public static final Setting<Long> read_timeout = Settings.setting((String)"ha.read_timeout", (Function)Settings.DURATION, (String)"20s");
    @Description(value="Timeout for waiting for instance to become master or slave")
    public static final Setting<Long> state_switch_timeout = Settings.setting((String)"ha.state_switch_timeout", (Function)Settings.DURATION, (String)"20s");
    @Description(value="Timeout for taking locks")
    public static final Setting<Long> lock_read_timeout = Settings.setting((String)"ha.lock_read_timeout", (Function)Settings.DURATION, read_timeout);
    @Description(value="Maximum number of connections a slave can have to the master")
    public static final Setting<Integer> max_concurrent_channels_per_slave = Settings.setting((String)"ha.max_concurrent_channels_per_slave", (Function)Settings.INTEGER, (String)"20", (Function2[])new Function2[]{Settings.min((Comparable)Integer.valueOf(1))});
    @Description(value="Where to bind High Availability protocol server")
    public static final Setting<HostnamePort> ha_server = Settings.setting((String)"ha.server", (Function)Settings.HOSTNAME_PORT, (String)":6001-6011");
    @Description(value="Whether this instance should only participate as slave in cluster. If enabled it will never be elected as master")
    public static final Setting<Boolean> slave_only = Settings.setting((String)"ha.slave_only", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="Policy for how to handle branched data")
    public static final Setting<BranchedDataPolicy> branched_data_policy = Settings.setting((String)"ha.branched_data_policy", (Function)Settings.options(BranchedDataPolicy.class), (String)"keep_all");
    @Description(value="List of ZooKeeper coordinators. Only needed for rolling upgrade from 1.8 to 1.9")
    @Deprecated
    public static Setting<List<HostnamePort>> coordinators = Settings.setting((String)"ha.upgrade_coordinators", (Function)Settings.list((String)",", (Function)Settings.HOSTNAME_PORT), (String)"");
    @Description(value="ZooKeeper session timeout. Only needed for rolling upgrade from 1.8 to 1.9")
    @Deprecated
    public static final Setting<Long> zk_session_timeout = Settings.setting((String)"ha.zk_session_timeout", (Function)Settings.DURATION, (String)"5s");
    @Description(value="Max size of the data chunks that flows between master and slaves in HA. Bigger size may increase throughput,but may be more sensitive to variations in bandwidth, whereas lower size increases tolerance for bandwidth variations. Examples: 500k or 3M. Must be within 1k-16M")
    public static final Setting<Long> com_chunk_size = Settings.setting((String)"ha.com_chunk_size", (Function)Settings.BYTES, (String)"2M", (Function2[])new Function2[]{Settings.min((Comparable)Long.valueOf(1024L))});
    @Description(value="Interval of pulling updates from master")
    public static final Setting<Long> pull_interval = Settings.setting((String)"ha.pull_interval", (Function)Settings.DURATION, (String)"0s");
    @Description(value="The amount of slaves the master will ask to replicate a committed transaction. The master will not throw an exception on commit if the replication failed.")
    public static final Setting<Integer> tx_push_factor = Settings.setting((String)"ha.tx_push_factor", (Function)Settings.INTEGER, (String)"1", (Function2[])new Function2[]{Settings.min((Comparable)Integer.valueOf(0))});
    @Description(value="Push strategy of a transaction to a slave during commit.  Round robin (\"round_robin\")   or fixed (\"fixed\") selecting the slave with highest machine id first")
    public static final Setting<TxPushStrategy> tx_push_strategy = Settings.setting((String)"ha.tx_push_strategy", (Function)Settings.options(TxPushStrategy.class), (String)"fixed");
    public static final Setting<Long> gcr_node_cache_size = GcrSettings.node_cache_size;
    public static final Setting<Long> gcr_relationship_cache_size = GcrSettings.relationship_cache_size;
    public static final Setting<Float> gcr_node_cache_array_fraction = GcrSettings.node_cache_array_fraction;
    public static final Setting<Float> gcr_relationship_cache_array_fraction = GcrSettings.relationship_cache_array_fraction;
    public static final Setting<Long> gcr_log_interval = GcrSettings.log_interval;

    public static enum TxPushStrategy {
        round_robin,
        fixed;

    }
}

