/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class BranchedDataMigrator
extends LifecycleAdapter {
    private final File storeDir;

    public BranchedDataMigrator(File storeDir) {
        this.storeDir = storeDir;
    }

    public void start() throws Throwable {
        this.migrateBranchedDataDirectoriesToRootDirectory();
    }

    private void migrateBranchedDataDirectoriesToRootDirectory() {
        File branchedDir = BranchedDataPolicy.getBranchedDataRootDirectory(this.storeDir);
        branchedDir.mkdirs();
        for (File oldBranchedDir : this.storeDir.listFiles()) {
            if (!oldBranchedDir.isDirectory() || !oldBranchedDir.getName().startsWith("branched-")) continue;
            long timestamp = 0L;
            try {
                timestamp = Long.parseLong(oldBranchedDir.getName().substring(oldBranchedDir.getName().indexOf(45) + 1));
            }
            catch (NumberFormatException e) {
                continue;
            }
            File targetDir = BranchedDataPolicy.getBranchedDataDirectory(this.storeDir, timestamp);
            try {
                FileUtils.moveFile((File)oldBranchedDir, (File)targetDir);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't move branched directories to " + branchedDir, e);
            }
        }
    }
}

