/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import org.neo4j.com.Response;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.TxExtractor;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;

public class HaXaDataSourceManager
extends XaDataSourceManager {
    public HaXaDataSourceManager(StringLogger msgLog) {
        super(msgLog);
    }

    public <T> T applyTransactions(Response<T> response) {
        return this.applyTransactions(response, ServerUtil.NO_ACTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T applyTransactions(Response<T> response, ServerUtil.TxHandler txHandler) {
        try {
            for (Triplet tx : IteratorUtil.asIterable((Iterator)response.transactions())) {
                String resourceName = (String)tx.first();
                XaDataSource dataSource = this.getXaDataSource(resourceName);
                txHandler.accept(tx, dataSource);
                ReadableByteChannel txStream = ((TxExtractor)tx.third()).extract();
                try {
                    dataSource.applyCommittedTransaction(((Long)tx.second()).longValue(), txStream);
                }
                finally {
                    txStream.close();
                }
            }
            txHandler.done();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            response.close();
        }
        return (T)response.response();
    }
}

