/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com;

import java.io.IOException;
import java.util.Collection;
import org.neo4j.com.RequestContext;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class RequestContextFactory {
    private final long startupTime;
    private final int serverId;
    private final XaDataSourceManager xaDsm;
    private final DependencyResolver resolver;

    public RequestContextFactory(int serverId, XaDataSourceManager xaDsm, DependencyResolver resolver) {
        this.resolver = resolver;
        this.startupTime = System.currentTimeMillis();
        this.serverId = serverId;
        this.xaDsm = xaDsm;
    }

    public RequestContext newRequestContext(int eventIdentifier) {
        try {
            Collection dataSources = this.xaDsm.getAllRegisteredDataSources();
            RequestContext.Tx[] txs = new RequestContext.Tx[dataSources.size()];
            int i = 0;
            Pair master = null;
            for (XaDataSource dataSource : dataSources) {
                long txId = dataSource.getLastCommittedTxId();
                if (dataSource.getName().equals("nioneodb")) {
                    master = dataSource.getMasterForCommittedTx(txId);
                }
                txs[i++] = RequestContext.lastAppliedTx((String)dataSource.getName(), (long)txId);
            }
            return new RequestContext(this.startupTime, this.serverId, eventIdentifier, txs, ((Integer)master.first()).intValue(), ((Long)master.other()).longValue());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RequestContext newRequestContext(long sessionId, int machineId, int eventIdentifier) {
        try {
            Collection dataSources = this.xaDsm.getAllRegisteredDataSources();
            RequestContext.Tx[] txs = new RequestContext.Tx[dataSources.size()];
            int i = 0;
            Pair master = null;
            for (XaDataSource dataSource : dataSources) {
                long txId = dataSource.getLastCommittedTxId();
                if (dataSource.getName().equals("nioneodb")) {
                    master = dataSource.getMasterForCommittedTx(txId);
                }
                txs[i++] = RequestContext.lastAppliedTx((String)dataSource.getName(), (long)txId);
            }
            return new RequestContext(sessionId, machineId, eventIdentifier, txs, ((Integer)master.first()).intValue(), ((Long)master.other()).longValue());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RequestContext newRequestContext(XaDataSource dataSource, long sessionId, int machineId, int eventIdentifier) {
        try {
            long txId = dataSource.getLastCommittedTxId();
            RequestContext.Tx[] txs = new RequestContext.Tx[]{RequestContext.lastAppliedTx((String)dataSource.getName(), (long)txId)};
            Pair master = dataSource.getName().equals("nioneodb") ? dataSource.getMasterForCommittedTx(txId) : Pair.of((Object)-1, (Object)0L);
            return new RequestContext(sessionId, machineId, eventIdentifier, txs, ((Integer)master.first()).intValue(), ((Long)master.other()).longValue());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RequestContext newRequestContext(XaDataSource dataSource) {
        return this.newRequestContext(dataSource, this.startupTime, this.serverId, ((AbstractTransactionManager)this.resolver.resolveDependency(AbstractTransactionManager.class)).getEventIdentifier());
    }

    public RequestContext newRequestContext() {
        return this.newRequestContext(this.startupTime, this.serverId, ((AbstractTransactionManager)this.resolver.resolveDependency(AbstractTransactionManager.class)).getEventIdentifier());
    }
}

