/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.net.URI;
import javax.transaction.TransactionManager;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.InstanceAccessGuard;
import org.neo4j.kernel.ha.cluster.AbstractModeSwitcher;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.SlaveLockManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockManagerImpl;
import org.neo4j.kernel.impl.transaction.RagManager;
import org.neo4j.kernel.impl.transaction.TxHook;

public class LockManagerModeSwitcher
extends AbstractModeSwitcher<LockManager> {
    private final AbstractTransactionManager txManager;
    private final TxHook txHook;
    private final HaXaDataSourceManager xaDsm;
    private final Master master;
    private final RequestContextFactory requestContextFactory;
    private final InstanceAccessGuard switchBlock;
    private final Config config;

    public LockManagerModeSwitcher(HighAvailabilityMemberStateMachine stateMachine, DelegateInvocationHandler<LockManager> delegate, AbstractTransactionManager txManager, TxHook txHook, HaXaDataSourceManager xaDsm, Master master, RequestContextFactory requestContextFactory, InstanceAccessGuard switchBlock, Config config) {
        super(stateMachine, delegate);
        this.txManager = txManager;
        this.txHook = txHook;
        this.xaDsm = xaDsm;
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.switchBlock = switchBlock;
        this.config = config;
    }

    @Override
    protected LockManager getMasterImpl() {
        return new LockManagerImpl(new RagManager((TransactionManager)this.txManager));
    }

    @Override
    protected LockManager getSlaveImpl(URI serverHaUri) {
        SlaveLockManager.Configuration slaveConfig = new SlaveLockManager.Configuration(){

            @Override
            public long getStateSwitchTimeout() {
                return (Long)LockManagerModeSwitcher.this.config.get(HaSettings.state_switch_timeout);
            }
        };
        return new SlaveLockManager(this.txManager, this.txHook, this.switchBlock, slaveConfig, new RagManager((TransactionManager)this.txManager), this.requestContextFactory, this.master, this.xaDsm);
    }
}

