/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.member.paxos.MemberIsAvailable;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastListener;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastSerializer;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.Payload;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.TargetDirectory;
import org.neo4j.tooling.GlobalGraphOperations;

public class HardKillIT {
    private static final File path = TargetDirectory.forTest(HardKillIT.class).graphDbDir(true);
    private ProcessStreamHandler processHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterSwitchHappensOnKillMinus9() throws Exception {
        Process proc = null;
        HighlyAvailableGraphDatabase dbWithId2 = null;
        HighlyAvailableGraphDatabase dbWithId3 = null;
        HighlyAvailableGraphDatabase oldMaster = null;
        try {
            proc = this.run("1");
            Thread.sleep(12000L);
            dbWithId2 = HardKillIT.startDb(2);
            dbWithId3 = HardKillIT.startDb(3);
            Assert.assertTrue((!dbWithId2.isMaster() ? 1 : 0) != 0);
            Assert.assertTrue((!dbWithId3.isMaster() ? 1 : 0) != 0);
            final CountDownLatch newMasterAvailableLatch = new CountDownLatch(1);
            ((ClusterClient)dbWithId2.getDependencyResolver().resolveDependency(ClusterClient.class)).addAtomicBroadcastListener(new AtomicBroadcastListener(){

                public void receive(Payload value) {
                    try {
                        Object event = new AtomicBroadcastSerializer((ObjectInputStreamFactory)new ObjectStreamFactory(), (ObjectOutputStreamFactory)new ObjectStreamFactory()).receive(value);
                        if (event instanceof MemberIsAvailable && "master".equals(((MemberIsAvailable)event).getRole())) {
                            newMasterAvailableLatch.countDown();
                        }
                    }
                    catch (Exception e) {
                        Assert.fail((String)e.toString());
                    }
                }
            });
            proc.destroy();
            proc = null;
            newMasterAvailableLatch.await(60L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)dbWithId2.isMaster());
            Assert.assertTrue((!dbWithId3.isMaster() ? 1 : 0) != 0);
            oldMaster = HardKillIT.startDb(1);
            long oldMasterNode = this.createNamedNode(oldMaster, "Old master");
            Assert.assertEquals((long)oldMasterNode, (long)this.getNamedNode(dbWithId2, "Old master"));
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
            if (oldMaster != null) {
                oldMaster.shutdown();
            }
            dbWithId2.shutdown();
            dbWithId3.shutdown();
        }
    }

    private long getNamedNode(HighlyAvailableGraphDatabase db, String name) {
        for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
            if (!name.equals(node.getProperty("name", null))) continue;
            return node.getId();
        }
        Assert.fail((String)("Couldn't find named node '" + name + "' at " + db));
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createNamedNode(HighlyAvailableGraphDatabase db, String name) {
        Transaction tx = db.beginTx();
        try {
            Node node = db.createNode();
            node.setProperty("name", (Object)name);
            tx.success();
            long l = node.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }

    private Process run(String machineId) throws IOException {
        ArrayList<String> allArgs = new ArrayList<String>(Arrays.asList("java", "-cp", System.getProperty("java.class.path"), HardKillIT.class.getName()));
        allArgs.add(machineId);
        Process process = Runtime.getRuntime().exec(allArgs.toArray(new String[allArgs.size()]));
        this.processHandler = new ProcessStreamHandler(process, false);
        this.processHandler.launch();
        return process;
    }

    public static void main(String[] args) {
        int machineId = Integer.parseInt(args[0]);
        HighlyAvailableGraphDatabase db = HardKillIT.startDb(machineId);
    }

    private static HighlyAvailableGraphDatabase startDb(int serverId) {
        GraphDatabaseBuilder builder = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(HardKillIT.path(serverId)).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5002,127.0.0.1:5003").setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + (5001 + serverId)).setConfig(ClusterSettings.server_id, "" + serverId).setConfig(HaSettings.ha_server, ":" + (8001 + serverId)).setConfig(HaSettings.tx_push_factor, "0");
        HighlyAvailableGraphDatabase db = (HighlyAvailableGraphDatabase)builder.newGraphDatabase();
        Transaction tx = db.beginTx();
        tx.finish();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return db;
    }

    private static String path(int i) {
        return new File(path, "" + i).getAbsolutePath();
    }
}

