/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.id;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.com.Response;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.IdRange;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class HaIdGeneratorFactoryTest {
    @Test
    public void slaveIdGeneratorShouldReturnFromAssignedRange() throws Exception {
        IdAllocation firstResult = new IdAllocation(new IdRange(new long[0], 42L, 123), 123L, 0L);
        Response toReturn = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)toReturn.response()).thenReturn((Object)firstResult);
        Master returning = (Master)Mockito.mock(Master.class);
        Mockito.when((Object)returning.allocateIds((IdType)Matchers.any())).thenReturn((Object)toReturn);
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        HaIdGeneratorFactory fac = new HaIdGeneratorFactory(returning, (Logging)new DevNullLoggingService());
        fac.switchToSlave();
        IdGenerator gen = fac.open((FileSystemAbstraction)fs, new File("someFile"), 10, IdType.NODE, 1L);
        for (long i = firstResult.getIdRange().getRangeStart(); i < (long)firstResult.getIdRange().getRangeLength(); ++i) {
            Assert.assertEquals((long)i, (long)gen.nextId());
        }
        ((Master)Mockito.verify((Object)returning, (VerificationMode)Mockito.times((int)1))).allocateIds(IdType.NODE);
    }

    @Test
    public void slaveIdGeneratorShouldAskForMoreWhenRangeIsOver() throws Exception {
        long i;
        IdAllocation firstResult = new IdAllocation(new IdRange(new long[0], 42L, 123), 165L, 0L);
        IdAllocation secondResult = new IdAllocation(new IdRange(new long[0], 1042L, 223), 1265L, 0L);
        Response toReturn = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)toReturn.response()).thenReturn((Object)firstResult, (Object[])new IdAllocation[]{secondResult});
        Master returning = (Master)Mockito.mock(Master.class);
        Mockito.when((Object)returning.allocateIds((IdType)Matchers.any())).thenReturn((Object)toReturn);
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        HaIdGeneratorFactory fac = new HaIdGeneratorFactory(returning, (Logging)new DevNullLoggingService());
        fac.switchToSlave();
        IdGenerator gen = fac.open((FileSystemAbstraction)fs, new File("someFile"), 10, IdType.NODE, 1L);
        long startAt = firstResult.getIdRange().getRangeStart();
        long forThatMany = firstResult.getIdRange().getRangeLength();
        for (i = startAt; i < startAt + forThatMany; ++i) {
            Assert.assertEquals((long)i, (long)gen.nextId());
        }
        ((Master)Mockito.verify((Object)returning, (VerificationMode)Mockito.times((int)1))).allocateIds(IdType.NODE);
        startAt = secondResult.getIdRange().getRangeStart();
        forThatMany = secondResult.getIdRange().getRangeLength();
        for (i = startAt; i < startAt + forThatMany; ++i) {
            Assert.assertEquals((long)i, (long)gen.nextId());
        }
        ((Master)Mockito.verify((Object)returning, (VerificationMode)Mockito.times((int)2))).allocateIds(IdType.NODE);
    }

    @Test
    public void shouldUseDefraggedIfPresent() throws Exception {
        long[] defragIds = new long[]{42L, 27172828L, 314159L};
        IdAllocation firstResult = new IdAllocation(new IdRange(defragIds, 0L, 0), 0L, (long)defragIds.length);
        Response toReturn = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)toReturn.response()).thenReturn((Object)firstResult);
        Master returning = (Master)Mockito.mock(Master.class);
        Mockito.when((Object)returning.allocateIds((IdType)Matchers.any())).thenReturn((Object)toReturn);
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        HaIdGeneratorFactory fac = new HaIdGeneratorFactory(returning, (Logging)new DevNullLoggingService());
        fac.switchToSlave();
        IdGenerator gen = fac.open((FileSystemAbstraction)fs, new File("someFile"), 10, IdType.NODE, 1L);
        for (int i = 0; i < defragIds.length; ++i) {
            Assert.assertEquals((long)defragIds[i], (long)gen.nextId());
        }
    }

    @Test
    public void shouldMoveFromDefraggedToRange() throws Exception {
        long[] defragIds = new long[]{42L, 27172828L, 314159L};
        IdAllocation firstResult = new IdAllocation(new IdRange(defragIds, 0L, 10), 100L, (long)defragIds.length);
        Response toReturn = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)toReturn.response()).thenReturn((Object)firstResult);
        Master returning = (Master)Mockito.mock(Master.class);
        Mockito.when((Object)returning.allocateIds((IdType)Matchers.any())).thenReturn((Object)toReturn);
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        HaIdGeneratorFactory fac = new HaIdGeneratorFactory(returning, (Logging)new DevNullLoggingService());
        fac.switchToSlave();
        IdGenerator gen = fac.open((FileSystemAbstraction)fs, new File("someFile"), 10, IdType.NODE, 1L);
        for (int i = 0; i < defragIds.length; ++i) {
            Assert.assertEquals((long)defragIds[i], (long)gen.nextId());
        }
    }

    @Test
    public void slaveShouldNeverAllowReducingHighId() throws Exception {
        int highIdFromAllocation = 123;
        IdAllocation firstResult = new IdAllocation(new IdRange(new long[0], 42L, 123), 123L, 0L);
        Response toReturn = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)toReturn.response()).thenReturn((Object)firstResult);
        Master returning = (Master)Mockito.mock(Master.class);
        Mockito.when((Object)returning.allocateIds((IdType)Matchers.any())).thenReturn((Object)toReturn);
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        HaIdGeneratorFactory fac = new HaIdGeneratorFactory(returning, (Logging)new DevNullLoggingService());
        fac.switchToSlave();
        IdGenerator gen = fac.open((FileSystemAbstraction)fs, new File("someFile"), 10, IdType.PROPERTY, 1L);
        int highIdFromUpdatedRecord = 124;
        gen.setHighId(124L);
        gen.nextId();
        Assert.assertEquals((long)124L, (long)gen.getHighId());
    }
}

