/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class ClusterTest {
    @Rule
    public LoggerRule logging = new LoggerRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCluster() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.fromXml(this.getClass().getResource("/threeinstances.xml").toURI()), TargetDirectory.forTest(this.getClass()).directory("testCluster", true), MapUtil.stringMap((String[])new String[]{HaSettings.ha_server.name(), ":6001-6005", HaSettings.tx_push_factor.name(), "2"}));
        try {
            clusterManager.start();
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            Transaction tx = master.beginTx();
            Node node = master.createNode();
            long nodeId = node.getId();
            node.setProperty("foo", (Object)"bar");
            tx.success();
            tx.finish();
            node = clusterManager.getDefaultCluster().getAnySlave(new HighlyAvailableGraphDatabase[0]).getNodeById(nodeId);
            Assert.assertThat((Object)node.getProperty("foo").toString(), (Matcher)CoreMatchers.equalTo((Object)"bar"));
        }
        finally {
            clusterManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testArbiterStartsFirstAndThenTwoInstancesJoin() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterWithAdditionalArbiters(2, 1), TargetDirectory.forTest(this.getClass()).directory("testCluster", true), MapUtil.stringMap((String[])new String[0]));
        try {
            clusterManager.start();
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            Transaction tx = master.beginTx();
            master.createNode();
            tx.success();
            tx.finish();
        }
        finally {
            clusterManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstancesWithConflictingClusterPorts() throws Throwable {
        HighlyAvailableGraphDatabase first = null;
        try {
            String masterStoreDir = TargetDirectory.forTest(this.getClass()).directory("testConflictingClusterPortsMaster", true).getAbsolutePath();
            first = (HighlyAvailableGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(masterStoreDir).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5001").setConfig(ClusterSettings.server_id, "1").setConfig(HaSettings.ha_server, "127.0.0.1:6666").newGraphDatabase();
            try {
                String slaveStoreDir = TargetDirectory.forTest(this.getClass()).directory("testConflictingClusterPortsSlave", true).getAbsolutePath();
                HighlyAvailableGraphDatabase failed = (HighlyAvailableGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(slaveStoreDir).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5001").setConfig(ClusterSettings.server_id, "2").setConfig(HaSettings.ha_server, "127.0.0.1:6667").newGraphDatabase();
                failed.shutdown();
                Assert.fail((String)"Should not start when ports conflict");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (first != null) {
                first.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstancesWithConflictingHaPorts() throws Throwable {
        HighlyAvailableGraphDatabase first = null;
        try {
            String storeDir = TargetDirectory.forTest(this.getClass()).directory("testConflictingHaPorts", true).getAbsolutePath();
            first = (HighlyAvailableGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(storeDir).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5001").setConfig(ClusterSettings.server_id, "1").setConfig(HaSettings.ha_server, "127.0.0.1:6666").newGraphDatabase();
            try {
                HighlyAvailableGraphDatabase failed = (HighlyAvailableGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(storeDir).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5002").setConfig(ClusterSettings.server_id, "2").setConfig(HaSettings.ha_server, "127.0.0.1:6666").newGraphDatabase();
                failed.shutdown();
                Assert.fail((String)"Should not start when ports conflict");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (first != null) {
                first.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void given4instanceClusterWhenMasterGoesDownThenElectNewMaster() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.fromXml(this.getClass().getResource("/fourinstances.xml").toURI()), TargetDirectory.forTest(this.getClass()).directory("4instances", true), MapUtil.stringMap((String[])new String[0]));
        try {
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            this.logging.getLogger().info("STOPPING MASTER");
            cluster.shutdown(cluster.getMaster());
            this.logging.getLogger().info("STOPPED MASTER");
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            this.logging.getLogger().info("CREATE NODE");
            Transaction tx = master.beginTx();
            master.createNode();
            this.logging.getLogger().info("CREATED NODE");
            tx.success();
            tx.finish();
            this.logging.getLogger().info("STOPPING CLUSTER");
        }
        finally {
            clusterManager.stop();
        }
    }
}

