/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.util.HashMap;
import javax.transaction.Transaction;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.com.RequestContext;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;

public class MasterImplTest {
    @Test
    public void givenStartedAndInaccessibleWhenInitializeTxThenThrowException() throws Throwable {
        MasterImpl.SPI spi = (MasterImpl.SPI)Mockito.mock(MasterImpl.SPI.class);
        DevNullLoggingService logging = new DevNullLoggingService();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(HaSettings.lock_read_timeout.name(), "20s");
        Config config = new Config(params, new Class[]{HaSettings.class});
        Mockito.when((Object)spi.isAccessible()).thenReturn((Object)false);
        MasterImpl instance = new MasterImpl(spi, (Logging)logging, config);
        instance.start();
        try {
            instance.initializeTx(new RequestContext(0L, 1, 2, new RequestContext.Tx[0], 1, 0L));
            Assert.fail();
        }
        catch (TransactionFailureException e) {
            // empty catch block
        }
    }

    @Test
    public void givenStartedAndAccessibleWhenInitializeTxThenSucceeds() throws Throwable {
        MasterImpl.SPI spi = (MasterImpl.SPI)Mockito.mock(MasterImpl.SPI.class);
        DevNullLoggingService logging = new DevNullLoggingService();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(HaSettings.lock_read_timeout.name(), "20s");
        Config config = new Config(params, new Class[]{HaSettings.class});
        Mockito.when((Object)spi.isAccessible()).thenReturn((Object)true);
        Mockito.when((Object)spi.beginTx()).thenReturn(Mockito.mock(Transaction.class));
        MasterImpl instance = new MasterImpl(spi, (Logging)logging, config);
        instance.start();
        try {
            instance.initializeTx(new RequestContext(0L, 1, 2, new RequestContext.Tx[0], 1, 0L));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

