/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.logging.ConsoleLogger;

public class HighAvailabilityConsoleLogger
implements ClusterMemberListener,
ClusterListener,
AvailabilityGuard.AvailabilityListener {
    private ConsoleLogger console;
    private InstanceId myId;

    public HighAvailabilityConsoleLogger(ConsoleLogger console, InstanceId myId) {
        this.console = console;
        this.myId = myId;
    }

    public void enteredCluster(ClusterConfiguration clusterConfiguration) {
        this.console.log(String.format("Instance %d (this server) joined the cluster", this.myId.toIntegerIndex()));
    }

    public void leftCluster() {
        this.console.log(String.format("Instance %d (this server) left the cluster", this.myId.toIntegerIndex()));
    }

    public void joinedCluster(InstanceId instanceId, URI member) {
        this.console.log("Instance " + instanceId + " joined the cluster");
    }

    public void leftCluster(InstanceId instanceId) {
        this.console.log("Instance " + instanceId + " has left the cluster");
    }

    public void elected(String role, InstanceId instanceId, URI electedMember) {
        this.console.log("Instance " + this.printId(instanceId) + "was elected as " + role);
    }

    public void unelected(String role, InstanceId instanceId, URI electedMember) {
        this.console.log("Instance " + this.printId(instanceId) + "was demoted as " + role);
    }

    public void coordinatorIsElected(InstanceId coordinatorId) {
    }

    public void memberIsAvailable(String role, InstanceId availableId, URI atUri) {
        this.console.log("Instance " + this.printId(availableId) + "is available as " + role + " at " + atUri.toASCIIString());
    }

    public void memberIsUnavailable(String role, InstanceId unavailableId) {
        this.console.log("Instance " + this.printId(unavailableId) + "is unavailable as " + role);
    }

    public void memberIsFailed(InstanceId instanceId) {
        this.console.log("Instance " + this.printId(instanceId) + "has failed");
    }

    public void memberIsAlive(InstanceId instanceId) {
        this.console.log("Instance " + this.printId(instanceId) + "is alive");
    }

    public void available() {
        this.console.log("Database available for write transactions");
    }

    public void unavailable() {
        this.console.log("Write transactions to database disabled");
    }

    private String printId(InstanceId id) {
        return id + (id.equals((Object)this.myId) ? " (this server) " : " ");
    }
}

