/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.slave;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.Deserializer;
import org.neo4j.com.MismatchingVersionHandler;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.TxExtractor;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.ha.lock.LockStatus;

public interface MasterClient
extends Master {
    public static final ObjectSerializer<LockResult> LOCK_SERIALIZER = new ObjectSerializer<LockResult>(){

        public void write(LockResult responseObject, ChannelBuffer result) throws IOException {
            result.writeByte(responseObject.getStatus().ordinal());
            if (responseObject.getStatus().hasMessage()) {
                Protocol.writeString((ChannelBuffer)result, (String)responseObject.getDeadlockMessage());
            }
        }
    };
    public static final Deserializer<LockResult> LOCK_RESULT_DESERIALIZER = new Deserializer<LockResult>(){

        public LockResult read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
            LockStatus status = LockStatus.values()[buffer.readByte()];
            return status.hasMessage() ? new LockResult(Protocol.readString((ChannelBuffer)buffer)) : new LockResult(status);
        }
    };

    @Override
    public Response<Integer> createRelationshipType(RequestContext var1, String var2);

    @Override
    public Response<Void> initializeTx(RequestContext var1);

    @Override
    public Response<LockResult> acquireNodeReadLock(RequestContext var1, long ... var2);

    @Override
    public Response<LockResult> acquireRelationshipWriteLock(RequestContext var1, long ... var2);

    @Override
    public Response<LockResult> acquireRelationshipReadLock(RequestContext var1, long ... var2);

    @Override
    public Response<LockResult> acquireGraphWriteLock(RequestContext var1);

    @Override
    public Response<LockResult> acquireGraphReadLock(RequestContext var1);

    @Override
    public Response<LockResult> acquireIndexReadLock(RequestContext var1, String var2, String var3);

    @Override
    public Response<LockResult> acquireIndexWriteLock(RequestContext var1, String var2, String var3);

    @Override
    public Response<Long> commitSingleResourceTransaction(RequestContext var1, String var2, TxExtractor var3);

    @Override
    public Response<Void> finishTransaction(RequestContext var1, boolean var2);

    public void rollbackOngoingTransactions(RequestContext var1);

    @Override
    public Response<Void> pullUpdates(RequestContext var1);

    @Override
    public Response<Void> copyStore(RequestContext var1, StoreWriter var2);

    @Override
    public Response<Void> copyTransactions(RequestContext var1, String var2, long var3, long var5);

    public void addMismatchingVersionHandler(MismatchingVersionHandler var1);
}

