/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.util.List;
import javax.transaction.Transaction;
import org.neo4j.com.Response;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockManagerImpl;
import org.neo4j.kernel.impl.transaction.LockNotFoundException;
import org.neo4j.kernel.impl.transaction.RagManager;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.info.LockInfo;
import org.neo4j.kernel.logging.Logging;

public class SlaveLockManager
implements LockManager {
    private final AbstractTransactionManager txManager;
    private final TxHook txHook;
    private final AvailabilityGuard availabilityGuard;
    private final Configuration config;
    private final RequestContextFactory requestContextFactory;
    private final LockManagerImpl local;
    private final Master master;
    private final HaXaDataSourceManager xaDsm;

    public SlaveLockManager(AbstractTransactionManager txManager, TxHook txHook, AvailabilityGuard availabilityGuard, Configuration config, RagManager ragManager, RequestContextFactory requestContextFactory, Master master, HaXaDataSourceManager xaDsm) {
        this.txManager = txManager;
        this.txHook = txHook;
        this.availabilityGuard = availabilityGuard;
        this.config = config;
        this.requestContextFactory = requestContextFactory;
        this.xaDsm = xaDsm;
        this.local = new LockManagerImpl(ragManager);
        this.master = master;
    }

    public long getDetectedDeadlockCount() {
        return this.local.getDetectedDeadlockCount();
    }

    public void getReadLock(Object resource) throws DeadlockDetectedException, IllegalResourceException {
        if (this.getReadLockOnMaster(resource)) {
            this.local.getReadLock(resource);
        }
    }

    public void getReadLock(Object resource, Transaction tx) throws DeadlockDetectedException, IllegalResourceException {
        if (this.getReadLockOnMaster(resource)) {
            this.local.getReadLock(resource, tx);
        }
    }

    private boolean getReadLockOnMaster(Object resource) {
        Response<LockResult> response = null;
        if (resource instanceof Node) {
            this.makeSureTxHasBeenInitialized();
            response = this.master.acquireNodeReadLock(this.requestContextFactory.newRequestContext(), ((Node)resource).getId());
        } else if (resource instanceof Relationship) {
            this.makeSureTxHasBeenInitialized();
            response = this.master.acquireRelationshipReadLock(this.requestContextFactory.newRequestContext(), ((Relationship)resource).getId());
        } else if (resource instanceof GraphProperties) {
            this.makeSureTxHasBeenInitialized();
            response = this.master.acquireGraphReadLock(this.requestContextFactory.newRequestContext());
        } else if (resource instanceof NodeManager.IndexLock) {
            this.makeSureTxHasBeenInitialized();
            NodeManager.IndexLock indexLock = (NodeManager.IndexLock)resource;
            response = this.master.acquireIndexReadLock(this.requestContextFactory.newRequestContext(), indexLock.getIndex(), indexLock.getKey());
        } else {
            return true;
        }
        return this.receiveLockResponse(response);
    }

    private boolean receiveLockResponse(Response<LockResult> response) {
        LockResult result = this.xaDsm.applyTransactions(response);
        switch (result.getStatus()) {
            case DEAD_LOCKED: {
                throw new DeadlockDetectedException(result.getDeadlockMessage());
            }
            case NOT_LOCKED: {
                throw new UnsupportedOperationException();
            }
            case OK_LOCKED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(result.toString());
            }
        }
        return true;
    }

    public void getWriteLock(Object resource) throws DeadlockDetectedException, IllegalResourceException {
        if (this.getWriteLockOnMaster(resource)) {
            this.local.getWriteLock(resource);
        }
    }

    public void getWriteLock(Object resource, Transaction tx) throws DeadlockDetectedException, IllegalResourceException {
        if (this.getWriteLockOnMaster(resource)) {
            this.local.getWriteLock(resource, tx);
        }
    }

    private boolean getWriteLockOnMaster(Object resource) {
        Response<LockResult> response = null;
        if (resource instanceof Node) {
            this.makeSureTxHasBeenInitialized();
            response = this.master.acquireNodeWriteLock(this.requestContextFactory.newRequestContext(), ((Node)resource).getId());
        } else if (resource instanceof Relationship) {
            this.makeSureTxHasBeenInitialized();
            response = this.master.acquireRelationshipWriteLock(this.requestContextFactory.newRequestContext(), ((Relationship)resource).getId());
        } else if (resource instanceof GraphProperties) {
            this.makeSureTxHasBeenInitialized();
            response = this.master.acquireGraphWriteLock(this.requestContextFactory.newRequestContext());
        } else if (resource instanceof NodeManager.IndexLock) {
            this.makeSureTxHasBeenInitialized();
            NodeManager.IndexLock indexLock = (NodeManager.IndexLock)resource;
            response = this.master.acquireIndexWriteLock(this.requestContextFactory.newRequestContext(), indexLock.getIndex(), indexLock.getKey());
        } else {
            return true;
        }
        return this.receiveLockResponse(response);
    }

    public void releaseReadLock(Object resource, Transaction tx) throws LockNotFoundException, IllegalResourceException {
        this.local.releaseReadLock(resource, tx);
    }

    public void releaseWriteLock(Object resource, Transaction tx) throws LockNotFoundException, IllegalResourceException {
        this.local.releaseWriteLock(resource, tx);
    }

    public void dumpLocksOnResource(Object resource, Logging logging) {
        this.local.dumpLocksOnResource(resource, logging);
    }

    public List<LockInfo> getAllLocks() {
        return this.local.getAllLocks();
    }

    public List<LockInfo> getAwaitedLocks(long minWaitTime) {
        return this.local.getAwaitedLocks(minWaitTime);
    }

    public void dumpRagStack(Logging logging) {
        this.local.dumpRagStack(logging);
    }

    public void dumpAllLocks(Logging logging) {
        this.local.dumpAllLocks(logging);
    }

    private void makeSureTxHasBeenInitialized() {
        int eventIdentifier = this.txManager.getEventIdentifier();
        if (!this.txManager.getTransactionState().hasLocks()) {
            if (!this.availabilityGuard.isAvailable(this.config.getAvailabilityTimeout())) {
                throw new RuntimeException("Timed out waiting for database to switch state");
            }
            this.txHook.initializeTransaction(eventIdentifier);
        }
    }

    public static interface Configuration {
        public long getAvailabilityTimeout();
    }
}

