/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleListener;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class ClusterTransactionTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenClusterWhenShutdownMasterThenCannotStartTransactionOnSlave() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.fromXml(this.getClass().getResource("/threeinstances.xml").toURI()), TargetDirectory.forTest(this.getClass()).directory("testCluster", true), MapUtil.stringMap((String[])new String[]{HaSettings.ha_server.name(), ":6001-6005", HaSettings.tx_push_factor.name(), "2"}));
        try {
            clusterManager.start();
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            HighlyAvailableGraphDatabase slave = clusterManager.getDefaultCluster().getAnySlave(new HighlyAvailableGraphDatabase[0]);
            final FutureTask result = new FutureTask(new Callable((GraphDatabaseAPI)slave){
                final /* synthetic */ GraphDatabaseAPI val$slave;
                {
                    this.val$slave = graphDatabaseAPI;
                }

                public Boolean call() throws Exception {
                    Transaction tx = this.val$slave.beginTx();
                    try {
                        tx.acquireWriteLock((PropertyContainer)this.val$slave.getNodeById(0L));
                        return false;
                    }
                    catch (Exception e) {
                        return true;
                    }
                }
            });
            ((LifeSupport)master.getDependencyResolver().resolveDependency(LifeSupport.class)).addLifecycleListener(new LifecycleListener(){

                public void notifyStatusChanged(Object instance, LifecycleStatus from, LifecycleStatus to) {
                    if (instance.getClass().getName().contains("DatabaseAvailability") && to == LifecycleStatus.STOPPED) {
                        result.run();
                    }
                }
            });
            master.shutdown();
            Assert.assertThat(result.get(), (Matcher)CoreMatchers.equalTo((Object)true));
        }
        finally {
            clusterManager.stop();
        }
    }
}

