/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import org.neo4j.cluster.protocol.election.ElectionCredentials;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentials;
import org.neo4j.kernel.ha.HighAvailabilityMemberInfoProvider;
import org.neo4j.kernel.ha.cluster.DefaultElectionCredentials;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.impl.core.LastTxIdGetter;

public class DefaultElectionCredentialsProvider
implements ElectionCredentialsProvider {
    private final int serverId;
    private final LastTxIdGetter lastTxIdGetter;
    private final HighAvailabilityMemberInfoProvider masterInfo;

    public DefaultElectionCredentialsProvider(int serverId, LastTxIdGetter lastTxIdGetter, HighAvailabilityMemberInfoProvider masterInfo) {
        this.serverId = serverId;
        this.lastTxIdGetter = lastTxIdGetter;
        this.masterInfo = masterInfo;
    }

    public ElectionCredentials getCredentials(String role) {
        if (this.masterInfo.getHighAvailabilityMemberState().isEligibleForElection()) {
            return new DefaultElectionCredentials(this.serverId, this.lastTxIdGetter.getLastTxId(), this.isMasterOrToMaster());
        }
        return new NotElectableElectionCredentials();
    }

    private boolean isMasterOrToMaster() {
        return this.masterInfo.getHighAvailabilityMemberState() == HighAvailabilityMemberState.MASTER || this.masterInfo.getHighAvailabilityMemberState() == HighAvailabilityMemberState.TO_MASTER;
    }
}

