/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.StoreWriter;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

class DefaultMasterImplSPI
implements MasterImpl.SPI {
    private static final int ID_GRAB_SIZE = 1000;
    private final GraphDatabaseAPI graphDb;
    private final Logging logging;
    private final TransactionManager txManager;

    public DefaultMasterImplSPI(GraphDatabaseAPI graphDb, Logging logging, TransactionManager txManager) {
        this.graphDb = graphDb;
        this.logging = logging;
        this.txManager = txManager;
    }

    @Override
    public boolean isAccessible() {
        return this.graphDb.isAvailable(5000L);
    }

    @Override
    public void acquireLock(MasterImpl.LockGrabber grabber, Object ... entities) {
        LockManager lockManager = this.graphDb.getLockManager();
        TransactionState state = ((AbstractTransactionManager)this.graphDb.getTxManager()).getTransactionState();
        for (Object entity : entities) {
            grabber.grab(lockManager, state, entity);
        }
    }

    @Override
    public Transaction beginTx() throws SystemException, NotSupportedException {
        this.txManager.begin();
        return this.txManager.getTransaction();
    }

    @Override
    public void finishTransaction(boolean success) {
        try {
            if (success) {
                this.txManager.commit();
            } else {
                this.txManager.rollback();
            }
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    @Override
    public void suspendTransaction() throws SystemException {
        this.txManager.suspend();
    }

    @Override
    public void resumeTransaction(Transaction transaction) {
        try {
            this.txManager.resume(transaction);
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    @Override
    public GraphProperties graphProperties() {
        return ((NodeManager)this.graphDb.getDependencyResolver().resolveDependency(NodeManager.class)).getGraphProperties();
    }

    @Override
    public IdAllocation allocateIds(IdType idType) {
        IdGenerator generator = this.graphDb.getIdGeneratorFactory().get(idType);
        return new IdAllocation(generator.nextIdBatch(1000), generator.getHighId(), generator.getDefragCount());
    }

    @Override
    public StoreId storeId() {
        return this.graphDb.getStoreId();
    }

    @Override
    public long applyPreparedTransaction(String resource, ReadableByteChannel preparedTransaction) throws IOException {
        XaDataSource dataSource = this.graphDb.getXaDataSourceManager().getXaDataSource(resource);
        return dataSource.applyPreparedTransaction(preparedTransaction);
    }

    @Override
    public Integer createRelationshipType(String name) {
        this.graphDb.getRelationshipTypeHolder().addValidRelationshipType(name, true);
        return this.graphDb.getRelationshipTypeHolder().getIdFor(name);
    }

    @Override
    public Pair<Integer, Long> getMasterIdForCommittedTx(long txId) throws IOException {
        NeoStoreXaDataSource nioneoDataSource = this.graphDb.getXaDataSourceManager().getNeoStoreDataSource();
        return nioneoDataSource.getMasterForCommittedTx(txId);
    }

    @Override
    public RequestContext rotateLogsAndStreamStoreFiles(StoreWriter writer) {
        return ServerUtil.rotateLogsAndStreamStoreFiles((String)this.graphDb.getStoreDir(), (XaDataSourceManager)this.graphDb.getXaDataSourceManager(), (KernelPanicEventGenerator)this.graphDb.getKernelPanicGenerator(), (StringLogger)this.logging.getMessagesLog(MasterImpl.class), (boolean)true, (StoreWriter)writer);
    }

    @Override
    public Response<Void> copyTransactions(String dsName, long startTxId, long endTxId) {
        return ServerUtil.getTransactions((GraphDatabaseAPI)this.graphDb, (String)dsName, (long)startTxId, (long)endTxId);
    }

    @Override
    public <T> Response<T> packResponse(RequestContext context, T response, Predicate<Long> filter) {
        return ServerUtil.packResponse((StoreId)this.graphDb.getStoreId(), (XaDataSourceManager)this.graphDb.getXaDataSourceManager(), (RequestContext)context, response, filter);
    }

    @Override
    public void pushTransaction(String resourceName, int eventIdentifier, long tx, int machineId) {
        this.graphDb.getTxIdGenerator().committed(this.graphDb.getXaDataSourceManager().getXaDataSource(resourceName), eventIdentifier, tx, Integer.valueOf(machineId));
    }
}

