/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import javax.transaction.Transaction;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.info.LockInfo;

public class LocalDeadlockDetectedException
extends DeadlockDetectedException {
    public LocalDeadlockDetectedException(LockManager lockManager, Transaction tx, Object resource, LockType type) {
        super(LocalDeadlockDetectedException.constructHelpfulDiagnosticsMessage(lockManager, tx, resource, type));
    }

    private static String constructHelpfulDiagnosticsMessage(LockManager lockManager, Transaction tx, Object resource, LockType type) {
        StringBuilder builder = new StringBuilder(String.format("%s tried to apply local %s lock on %s after acquired on master. Currently these locks exist:%n", tx, type, resource));
        for (LockInfo lock : lockManager.getAllLocks()) {
            if (lock.getReadCount() <= 0 && lock.getWriteCount() <= 0) continue;
            builder.append(String.format(lock.toString(), new Object[0]));
        }
        return builder.toString();
    }
}

