/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import org.neo4j.com.Response;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.transaction.TxHookModeSwitcher;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;

public class SlaveTxHook
implements RemoteTxHook {
    private final Master master;
    private final HaXaDataSourceManager xaDsm;
    private final RequestContextFactory contextFactory;

    public SlaveTxHook(Master master, HaXaDataSourceManager xaDsm, TxHookModeSwitcher.RequestContextFactoryResolver contextFactory) {
        this.master = master;
        this.xaDsm = xaDsm;
        this.contextFactory = contextFactory.get();
    }

    public void remotelyInitializeTransaction(int eventIdentifier) {
        Response<Void> response = this.master.initializeTx(this.contextFactory.newRequestContext(eventIdentifier));
        this.xaDsm.applyTransactions(response);
    }

    public void remotelyFinishTransaction(int eventIdentifier, boolean success) {
        Response<Void> response = this.master.finishTransaction(this.contextFactory.newRequestContext(eventIdentifier), success);
        this.xaDsm.applyTransactions(response);
    }

    public boolean freeIdsDuringRollback() {
        return false;
    }
}

